/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Set;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.configuration.elasticsearch", description="Logs related to the Elasticsearch-specific backend configuration.\n")
@MessageLogger(projectCode="HSEARCH")
public interface ConfigurationLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.configuration.elasticsearch";
    public static final ConfigurationLog INSTANCE = (ConfigurationLog)LoggerFactory.make(ConfigurationLog.class, (String)"org.hibernate.search.configuration.elasticsearch", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=400022, value="Invalid index status: '%1$s'. Valid statuses are: %2$s.")
    public SearchException invalidIndexStatus(String var1, List<String> var2);

    @Message(id=400515, value="Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidMultiTenancyStrategyName(String var1, List<String> var2);

    @Message(id=400516, value="Invalid tenant identifiers: '%1$s'. No tenant identifier is expected, because multi-tenancy is disabled for this backend.")
    public SearchException tenantIdProvidedButMultiTenancyDisabled(Set<String> var1, @Param EventContext var2);

    @Message(id=400517, value="Missing tenant identifier. A tenant identifier is expected, because multi-tenancy is enabled for this backend.")
    public SearchException multiTenancyEnabledButNoTenantIdProvided(@Param EventContext var1);

    @Message(id=400558, value="Invalid Elasticsearch distribution name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidElasticsearchDistributionName(String var1, List<String> var2);

    @Message(id=400589, value="Invalid host/port: '%1$s'. The host/port string must use the format 'host:port', for example 'mycompany.com:9200' The URI scheme ('http://', 'https://') must not be included.")
    public SearchException invalidHostAndPort(String var1, @Cause Exception var2);

    @Message(id=400591, value="Invalid name for the type-name mapping strategy: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidTypeNameMappingStrategyName(String var1, List<String> var2);

    @Message(id=400621, value="Invalid dynamic type: '%1$s'. Valid values are: %2$s.")
    public SearchException invalidDynamicType(String var1, List<String> var2);

    @Message(id=400626, value="Invalid target hosts configuration: both the 'uris' property and the 'protocol' property are set. Uris: '%1$s'. Protocol: '%2$s'. Either set the protocol and hosts simultaneously using the 'uris' property, or set them separately using the 'protocol' property and the 'hosts' property.")
    public SearchException uriAndProtocol(List<String> var1, String var2);

    @Message(id=400627, value="Invalid target hosts configuration: both the 'uris' property and the 'hosts' property are set. Uris: '%1$s'. Hosts: '%2$s'. Either set the protocol and hosts simultaneously using the 'uris' property, or set them separately using the 'protocol' property and the 'hosts' property.")
    public SearchException uriAndHosts(List<String> var1, List<String> var2);

    @Message(id=400628, value="Invalid target hosts configuration: the 'uris' use different protocols (http, https). All URIs must use the same protocol. Uris: '%1$s'.")
    public SearchException differentProtocolsOnUris(List<String> var1);

    @Message(id=400629, value="Invalid target hosts configuration: the list of hosts must not be empty.")
    public SearchException emptyListOfHosts();

    @Message(id=400630, value="Invalid target hosts configuration: the list of URIs must not be empty.")
    public SearchException emptyListOfUris();

    @Message(id=400648, value="Invalid backend configuration: mapping requires multi-tenancy but no multi-tenancy strategy is set.")
    public SearchException multiTenancyRequiredButExplicitlyDisabledByBackend();

    @Message(id=400649, value="Invalid backend configuration: mapping requires single-tenancy but multi-tenancy strategy is set.")
    public SearchException multiTenancyNotRequiredButExplicitlyEnabledByTheBackend();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=400692, value="Elasticsearch backend will use client factory '%s'. Context: %s")
    public void backendClientFactory(BeanHolder<?> var1, String var2);
}

