/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.logging.impl.ConfigurationLog;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;

public class ConfigurationLog_$logger
implements ConfigurationLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigurationLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public ConfigurationLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String invalidIndexStatus$str() {
        return "HSEARCH400022: Invalid index status: '%1$s'. Valid statuses are: %2$s.";
    }

    @Override
    public final SearchException invalidIndexStatus(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIndexStatus$str(), invalidRepresentation, validRepresentations));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String invalidMultiTenancyStrategyName$str() {
        return "HSEARCH400515: Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidMultiTenancyStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMultiTenancyStrategyName$str(), invalidRepresentation, validRepresentations));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String tenantIdProvidedButMultiTenancyDisabled$str() {
        return "HSEARCH400516: Invalid tenant identifiers: '%1$s'. No tenant identifier is expected, because multi-tenancy is disabled for this backend.";
    }

    @Override
    public final SearchException tenantIdProvidedButMultiTenancyDisabled(Set<String> tenantIds, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.tenantIdProvidedButMultiTenancyDisabled$str(), tenantIds), context);
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiTenancyEnabledButNoTenantIdProvided$str() {
        return "HSEARCH400517: Missing tenant identifier. A tenant identifier is expected, because multi-tenancy is enabled for this backend.";
    }

    @Override
    public final SearchException multiTenancyEnabledButNoTenantIdProvided(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyEnabledButNoTenantIdProvided$str(), new Object[0]), context);
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidElasticsearchDistributionName$str() {
        return "HSEARCH400558: Invalid Elasticsearch distribution name: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidElasticsearchDistributionName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchDistributionName$str(), invalidRepresentation, validRepresentations));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidHostAndPort$str() {
        return "HSEARCH400589: Invalid host/port: '%1$s'. The host/port string must use the format 'host:port', for example 'mycompany.com:9200' The URI scheme ('http://', 'https://') must not be included.";
    }

    @Override
    public final SearchException invalidHostAndPort(String hostAndPort, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidHostAndPort$str(), hostAndPort), (Throwable)e);
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidTypeNameMappingStrategyName$str() {
        return "HSEARCH400591: Invalid name for the type-name mapping strategy: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidTypeNameMappingStrategyName(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidTypeNameMappingStrategyName$str(), invalidRepresentation, validRepresentations));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidDynamicType$str() {
        return "HSEARCH400621: Invalid dynamic type: '%1$s'. Valid values are: %2$s.";
    }

    @Override
    public final SearchException invalidDynamicType(String invalidRepresentation, List<String> validRepresentations) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDynamicType$str(), invalidRepresentation, validRepresentations));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String uriAndProtocol$str() {
        return "HSEARCH400626: Invalid target hosts configuration: both the 'uris' property and the 'protocol' property are set. Uris: '%1$s'. Protocol: '%2$s'. Either set the protocol and hosts simultaneously using the 'uris' property, or set them separately using the 'protocol' property and the 'hosts' property.";
    }

    @Override
    public final SearchException uriAndProtocol(List<String> uris, String protocol) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.uriAndProtocol$str(), uris, protocol));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String uriAndHosts$str() {
        return "HSEARCH400627: Invalid target hosts configuration: both the 'uris' property and the 'hosts' property are set. Uris: '%1$s'. Hosts: '%2$s'. Either set the protocol and hosts simultaneously using the 'uris' property, or set them separately using the 'protocol' property and the 'hosts' property.";
    }

    @Override
    public final SearchException uriAndHosts(List<String> uris, List<String> hosts) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.uriAndHosts$str(), uris, hosts));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String differentProtocolsOnUris$str() {
        return "HSEARCH400628: Invalid target hosts configuration: the 'uris' use different protocols (http, https). All URIs must use the same protocol. Uris: '%1$s'.";
    }

    @Override
    public final SearchException differentProtocolsOnUris(List<String> uris) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentProtocolsOnUris$str(), uris));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String emptyListOfHosts$str() {
        return "HSEARCH400629: Invalid target hosts configuration: the list of hosts must not be empty.";
    }

    @Override
    public final SearchException emptyListOfHosts() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.emptyListOfHosts$str(), new Object[0]));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String emptyListOfUris$str() {
        return "HSEARCH400630: Invalid target hosts configuration: the list of URIs must not be empty.";
    }

    @Override
    public final SearchException emptyListOfUris() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.emptyListOfUris$str(), new Object[0]));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiTenancyRequiredButExplicitlyDisabledByBackend$str() {
        return "HSEARCH400648: Invalid backend configuration: mapping requires multi-tenancy but no multi-tenancy strategy is set.";
    }

    @Override
    public final SearchException multiTenancyRequiredButExplicitlyDisabledByBackend() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyRequiredButExplicitlyDisabledByBackend$str(), new Object[0]));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str() {
        return "HSEARCH400649: Invalid backend configuration: mapping requires single-tenancy but multi-tenancy strategy is set.";
    }

    @Override
    public final SearchException multiTenancyNotRequiredButExplicitlyEnabledByTheBackend() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyNotRequiredButExplicitlyEnabledByTheBackend$str(), new Object[0]));
        ConfigurationLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void backendClientFactory(BeanHolder<?> clientFactoryHolder, String eventContext) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.backendClientFactory$str(), clientFactoryHolder, (Object)eventContext);
    }

    protected String backendClientFactory$str() {
        return "HSEARCH400692: Elasticsearch backend will use client factory '%s'. Context: %s";
    }
}

