/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.elasticsearch", description="The main category for the Elasticsearch backend-specific logs.\nIt may also include logs that do not fit any other, more specific, Elasticsearch category.\n")
@MessageLogger(projectCode="HSEARCH")
public interface ElasticsearchMiscLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.elasticsearch";
    public static final ElasticsearchMiscLog INSTANCE = (ElasticsearchMiscLog)LoggerFactory.make(ElasticsearchMiscLog.class, (String)"org.hibernate.search.elasticsearch", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=400506, value="Invalid target for Elasticsearch extension: '%1$s'. This extension can only be applied to components created by an Elasticsearch backend.")
    public SearchException elasticsearchExtensionOnUnknownType(Object var1);

    @Message(id=400518, value="Invalid requested type for client: '%1$s'. The Elasticsearch low-level client can only be unwrapped to '%2$s'.")
    public SearchException clientUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=400519, value="Invalid requested type for this backend: '%1$s'. Elasticsearch backends can only be unwrapped to '%2$s'.")
    public SearchException backendUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=400533, value="Invalid requested type for this index manager: '%1$s'. Elasticsearch index managers can only be unwrapped to '%2$s'.")
    public SearchException indexManagerUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=400657, value="Unable to export the schema for '%1$s' index: %2$s")
    public SearchException unableToExportSchema(String var1, String var2, @Cause IOException var3);

    @Message(id=400676, value="Cannot execute '%s' because Amazon OpenSearch Serverless does not support this operation. Either avoid this operation or switch to another Elasticsearch/OpenSearch distribution.")
    public SearchException cannotExecuteOperationOnAmazonOpenSearchServerless(String var1);

    @Message(id=400677, value="The targeted Elasticsearch cluster does not expose index status, so index status requirements cannot be enforced.")
    public SearchException cannotRequireIndexStatus();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=400691, value="Normalizing index name from '%1$s' to '%2$s'")
    public void normalizeIndexName(String var1, String var2);
}

