/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.ElasticsearchDistributionName;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@CategorizedLogger(category="org.hibernate.search.version.elasticsearch", description="Logs related to the Elasticsearch/OpenSearch version.\n")
@MessageLogger(projectCode="HSEARCH")
public interface VersionLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.version.elasticsearch";
    public static final VersionLog INSTANCE = (VersionLog)LoggerFactory.make(VersionLog.class, (String)"org.hibernate.search.version.elasticsearch", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=400080, value="Unable to detect the Elasticsearch version running on the cluster: %s")
    public SearchException failedToDetectElasticsearchVersion(String var1, @Cause Exception var2);

    @Message(id=400081, value="Incompatible Elasticsearch version: '%s'. Refer to the documentation to know which versions of Elasticsearch are compatible with Hibernate Search.")
    public SearchException unsupportedElasticsearchVersion(ElasticsearchVersion var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400085, value="Unknown Elasticsearch version running on the cluster: '%s'. Hibernate Search may not work correctly. Consider updating to a newer version of Hibernate Search, if any.")
    public void unknownElasticsearchVersion(ElasticsearchVersion var1);

    @Message(id=400556, value="Invalid Elasticsearch version: '%1$s'. Expected format is 'x.y.z-qualifier', where 'x', 'y' and 'z' are integers, and 'qualifier' is an string of word characters (alphanumeric or '_'). Incomplete versions are allowed, for example '7.0' or just '7'.")
    public SearchException invalidElasticsearchVersionWithoutDistribution(String var1, @Cause Throwable var2);

    @Message(id=400557, value="Invalid Elasticsearch version: '%1$s'. Expected format is 'x.y.z-qualifier' or '<distribution>:x.y.z-qualifier' or just '<distribution>', where '<distribution>' is one of %2$s (defaults to '%3$s'), 'x', 'y' and 'z' are integers, and 'qualifier' is an string of word characters (alphanumeric or '_'). Incomplete versions are allowed, for example 'elastic:7.0', '7.0' or just '7'. Note that the format '<distribution>' without a version number is only useful for distributions that don't support version numbers, such as Amazon OpenSearch Serverless.")
    public SearchException invalidElasticsearchVersionWithOptionalDistribution(String var1, List<String> var2, String var3, @Cause Throwable var4);

    @Message(id=400559, value="Unexpected Elasticsearch version running on the cluster: '%2$s'. Hibernate Search was configured for Elasticsearch '%1$s'.")
    public SearchException unexpectedElasticsearchVersion(ElasticsearchVersion var1, ElasticsearchVersion var2);

    @Message(id=400597, value="Missing or imprecise Elasticsearch version: configuration property '%1$s' is set to 'false', so you must set the version explicitly with at least as much precision as 'x.y', where 'x' and 'y' are integers.")
    public SearchException impreciseElasticsearchVersionWhenVersionCheckDisabled(String var1);

    @Message(id=400641, value="Incompatible Elasticsearch version: version '%2$s' does not match version '%1$s' that was provided when the backend was created. You can provide a more precise version on startup, but you cannot override the version that was provided when the backend was created.")
    public SearchException incompatibleElasticsearchVersionOnStart(ElasticsearchVersion var1, ElasticsearchVersion var2);

    @Message(id=400673, value="The targeted Elasticsearch cluster is reachable, but does not expose its version. Check that the configured Elasticsearch hosts/URI points to the right server. If you are targeting Amazon OpenSearch Serverless, you must set the configuration property '%1$s' explicitly to '%2$s'. See the reference documentation for more information.")
    public SearchException unableToFetchElasticsearchVersion(String var1, ElasticsearchVersion var2);

    @Message(id=400674, value="Cannot check the Elasticsearch version because the targeted Elasticsearch distribution '%s' does not expose its version.")
    public SearchException cannotCheckElasticsearchVersion(ElasticsearchDistributionName var1);

    @Message(id=400675, value="Unexpected Amazon OpenSearch Serverless version: '%1$s'. Amazon OpenSearch Serverless doesn't use version numbers. Set the version to simply '%2$s'.")
    public SearchException unexpectedAwsOpenSearchServerlessVersion(ElasticsearchVersion var1, ElasticsearchVersion var2);

    @Message(id=400685, value="The targeted %1$s version is not compatible with the Hibernate Search integration of vector search. To get vector search integration, upgrade your %1$s cluster to version %2$s or later, and if you configured the %1$s version in Hibernate Search, update it accordingly.")
    public SearchException searchBackendVersionIncompatibleWithVectorIntegration(String var1, String var2);
}

