/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.hibernate.search.backend.elasticsearch.ElasticsearchDistributionName;
import org.hibernate.search.backend.elasticsearch.ElasticsearchVersion;
import org.hibernate.search.backend.elasticsearch.logging.impl.VersionLog;
import org.hibernate.search.util.common.SearchException;
import org.jboss.logging.Logger;

public class VersionLog_$logger
implements VersionLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = VersionLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public VersionLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String failedToDetectElasticsearchVersion$str() {
        return "HSEARCH400080: Unable to detect the Elasticsearch version running on the cluster: %s";
    }

    @Override
    public final SearchException failedToDetectElasticsearchVersion(String causeMessage, Exception e) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.failedToDetectElasticsearchVersion$str(), causeMessage), (Throwable)e);
        VersionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String unsupportedElasticsearchVersion$str() {
        return "HSEARCH400081: Incompatible Elasticsearch version: '%s'. Refer to the documentation to know which versions of Elasticsearch are compatible with Hibernate Search.";
    }

    @Override
    public final SearchException unsupportedElasticsearchVersion(ElasticsearchVersion version) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unsupportedElasticsearchVersion$str(), version));
        VersionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void unknownElasticsearchVersion(ElasticsearchVersion version) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.unknownElasticsearchVersion$str(), (Object)version);
    }

    protected String unknownElasticsearchVersion$str() {
        return "HSEARCH400085: Unknown Elasticsearch version running on the cluster: '%s'. Hibernate Search may not work correctly. Consider updating to a newer version of Hibernate Search, if any.";
    }

    protected String invalidElasticsearchVersionWithoutDistribution$str() {
        return "HSEARCH400556: Invalid Elasticsearch version: '%1$s'. Expected format is 'x.y.z-qualifier', where 'x', 'y' and 'z' are integers, and 'qualifier' is an string of word characters (alphanumeric or '_'). Incomplete versions are allowed, for example '7.0' or just '7'.";
    }

    @Override
    public final SearchException invalidElasticsearchVersionWithoutDistribution(String invalidRepresentation, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchVersionWithoutDistribution$str(), invalidRepresentation), cause);
        VersionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidElasticsearchVersionWithOptionalDistribution$str() {
        return "HSEARCH400557: Invalid Elasticsearch version: '%1$s'. Expected format is 'x.y.z-qualifier' or '<distribution>:x.y.z-qualifier' or just '<distribution>', where '<distribution>' is one of %2$s (defaults to '%3$s'), 'x', 'y' and 'z' are integers, and 'qualifier' is an string of word characters (alphanumeric or '_'). Incomplete versions are allowed, for example 'elastic:7.0', '7.0' or just '7'. Note that the format '<distribution>' without a version number is only useful for distributions that don't support version numbers, such as Amazon OpenSearch Serverless.";
    }

    @Override
    public final SearchException invalidElasticsearchVersionWithOptionalDistribution(String invalidRepresentation, List<String> validDistributions, String defaultDistribution, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidElasticsearchVersionWithOptionalDistribution$str(), invalidRepresentation, validDistributions, defaultDistribution), cause);
        VersionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unexpectedElasticsearchVersion$str() {
        return "HSEARCH400559: Unexpected Elasticsearch version running on the cluster: '%2$s'. Hibernate Search was configured for Elasticsearch '%1$s'.";
    }

    @Override
    public final SearchException unexpectedElasticsearchVersion(ElasticsearchVersion configuredVersion, ElasticsearchVersion actualVersion) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedElasticsearchVersion$str(), configuredVersion, actualVersion));
        VersionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String impreciseElasticsearchVersionWhenVersionCheckDisabled$str() {
        return "HSEARCH400597: Missing or imprecise Elasticsearch version: configuration property '%1$s' is set to 'false', so you must set the version explicitly with at least as much precision as 'x.y', where 'x' and 'y' are integers.";
    }

    @Override
    public final SearchException impreciseElasticsearchVersionWhenVersionCheckDisabled(String versionCheckPropertyKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.impreciseElasticsearchVersionWhenVersionCheckDisabled$str(), versionCheckPropertyKey));
        VersionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String incompatibleElasticsearchVersionOnStart$str() {
        return "HSEARCH400641: Incompatible Elasticsearch version: version '%2$s' does not match version '%1$s' that was provided when the backend was created. You can provide a more precise version on startup, but you cannot override the version that was provided when the backend was created.";
    }

    @Override
    public final SearchException incompatibleElasticsearchVersionOnStart(ElasticsearchVersion versionOnCreation, ElasticsearchVersion versionOnStart) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.incompatibleElasticsearchVersionOnStart$str(), versionOnCreation, versionOnStart));
        VersionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unableToFetchElasticsearchVersion$str() {
        return "HSEARCH400673: The targeted Elasticsearch cluster is reachable, but does not expose its version. Check that the configured Elasticsearch hosts/URI points to the right server. If you are targeting Amazon OpenSearch Serverless, you must set the configuration property '%1$s' explicitly to '%2$s'. See the reference documentation for more information.";
    }

    @Override
    public final SearchException unableToFetchElasticsearchVersion(String versionConfigPropertyKey, ElasticsearchVersion expectedAWSOpenSearchServerlessVersion) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToFetchElasticsearchVersion$str(), versionConfigPropertyKey, expectedAWSOpenSearchServerlessVersion));
        VersionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotCheckElasticsearchVersion$str() {
        return "HSEARCH400674: Cannot check the Elasticsearch version because the targeted Elasticsearch distribution '%s' does not expose its version.";
    }

    @Override
    public final SearchException cannotCheckElasticsearchVersion(ElasticsearchDistributionName distributionName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCheckElasticsearchVersion$str(), new Object[]{distributionName}));
        VersionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String unexpectedAwsOpenSearchServerlessVersion$str() {
        return "HSEARCH400675: Unexpected Amazon OpenSearch Serverless version: '%1$s'. Amazon OpenSearch Serverless doesn't use version numbers. Set the version to simply '%2$s'.";
    }

    @Override
    public final SearchException unexpectedAwsOpenSearchServerlessVersion(ElasticsearchVersion configuredVersion, ElasticsearchVersion expectedAWSOpenSearchServerlessVersion) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedAwsOpenSearchServerlessVersion$str(), configuredVersion, expectedAWSOpenSearchServerlessVersion));
        VersionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String searchBackendVersionIncompatibleWithVectorIntegration$str() {
        return "HSEARCH400685: The targeted %1$s version is not compatible with the Hibernate Search integration of vector search. To get vector search integration, upgrade your %1$s cluster to version %2$s or later, and if you configured the %1$s version in Hibernate Search, update it accordingly.";
    }

    @Override
    public final SearchException searchBackendVersionIncompatibleWithVectorIntegration(String distribution, String version) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.searchBackendVersionIncompatibleWithVectorIntegration$str(), distribution, version));
        VersionLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }
}

