/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.schema.management.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchMiscLog;
import org.hibernate.search.backend.elasticsearch.schema.management.ElasticsearchIndexSchemaExport;

public class ElasticsearchIndexSchemaExportImpl
implements ElasticsearchIndexSchemaExport {
    private final Gson userFacingGson;
    private final String indexName;
    private final ElasticsearchRequest request;

    public ElasticsearchIndexSchemaExportImpl(Gson userFacingGson, String indexName, ElasticsearchRequest request) {
        this.userFacingGson = userFacingGson;
        this.indexName = indexName;
        this.request = request;
    }

    public void toFiles(Path targetDirectory) {
        JsonObject queryParams = new JsonObject();
        for (Map.Entry<String, String> entry : this.request.parameters().entrySet()) {
            queryParams.addProperty(entry.getKey(), entry.getValue());
        }
        List<JsonObject> parts = this.request.bodyParts();
        JsonElement body = parts.size() == 1 ? (JsonElement)parts.get(0) : (JsonElement)parts.stream().collect(JsonArray::new, JsonArray::add, JsonArray::addAll);
        this.write(targetDirectory, "create-index.json", body);
        this.write(targetDirectory, "create-index-query-params.json", (JsonElement)queryParams);
    }

    private void write(Path path, String filename, JsonElement data) {
        try (OutputStream outputStream = Files.newOutputStream(Files.createDirectories(path, new FileAttribute[0]).resolve(filename), new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
             JsonWriter jsonWriter = new JsonWriter((Writer)writer);){
            this.userFacingGson.toJson(data, jsonWriter);
            jsonWriter.flush();
        }
        catch (IOException e) {
            throw ElasticsearchMiscLog.INSTANCE.unableToExportSchema(this.indexName, e.getMessage(), e);
        }
    }

    @Override
    public Map<String, String> parameters() {
        return Collections.unmodifiableMap(this.request.parameters());
    }

    @Override
    public List<JsonObject> bodyParts() {
        return Collections.unmodifiableList(this.request.bodyParts());
    }
}

