/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.AbstractElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.cfg.spi.NumberUtils;

public final class ElasticsearchByteFieldCodec
extends AbstractElasticsearchFieldCodec<Byte> {
    public ElasticsearchByteFieldCodec(Gson gson) {
        super(gson);
    }

    @Override
    public JsonElement encode(Byte value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive((Number)value);
    }

    @Override
    public Byte decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return JsonElementTypes.BYTE.fromElement(element);
    }

    @Override
    public Byte decode(Double value) {
        return NumberUtils.toByte((Double)value);
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> other) {
        return other instanceof ElasticsearchByteFieldCodec;
    }
}

