/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.dsl.impl;

import org.hibernate.search.backend.elasticsearch.logging.impl.MappingLog;
import org.hibernate.search.backend.elasticsearch.lowlevel.index.mapping.impl.PropertyMapping;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchExistsPredicate;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ElasticsearchFieldProjection;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.AbstractElasticsearchVectorFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.AbstractElasticsearchIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.elasticsearch.types.dsl.impl.ElasticsearchIndexFieldTypeBuildContext;
import org.hibernate.search.backend.elasticsearch.types.impl.ElasticsearchIndexValueFieldType;
import org.hibernate.search.backend.elasticsearch.types.mapping.impl.ElasticsearchVectorFieldTypeMappingContributor;
import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.VectorSimilarity;
import org.hibernate.search.engine.backend.types.dsl.VectorFieldTypeOptionsStep;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;
import org.hibernate.search.util.common.AssertionFailure;

abstract class AbstractElasticsearchVectorFieldTypeOptionsStep<S extends AbstractElasticsearchVectorFieldTypeOptionsStep<?, F>, F>
extends AbstractElasticsearchIndexFieldTypeOptionsStep<S, F>
implements VectorFieldTypeOptionsStep<S, F>,
ElasticsearchVectorFieldTypeMappingContributor.Context {
    private final ElasticsearchVectorFieldTypeMappingContributor mappingContributor;
    protected VectorSimilarity vectorSimilarity = VectorSimilarity.DEFAULT;
    protected Integer dimension;
    protected Integer efConstruction;
    protected Integer m;
    protected F indexNullAs;
    private Projectable projectable = Projectable.DEFAULT;
    private Searchable searchable = Searchable.DEFAULT;

    AbstractElasticsearchVectorFieldTypeOptionsStep(ElasticsearchIndexFieldTypeBuildContext buildContext, Class<F> fieldType, ElasticsearchVectorFieldTypeMappingContributor mappingContributor) {
        super(buildContext, fieldType, new PropertyMapping());
        this.mappingContributor = mappingContributor;
    }

    public S searchable(Searchable searchable) {
        this.searchable = searchable;
        return (S)((AbstractElasticsearchVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S projectable(Projectable projectable) {
        this.projectable = projectable;
        return (S)((AbstractElasticsearchVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S indexNullAs(F indexNullAs) {
        this.indexNullAs = indexNullAs;
        return (S)((AbstractElasticsearchVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S vectorSimilarity(VectorSimilarity vectorSimilarity) {
        this.vectorSimilarity = vectorSimilarity;
        return (S)((AbstractElasticsearchVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S efConstruction(int efConstruction) {
        this.efConstruction = efConstruction;
        return (S)((AbstractElasticsearchVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S m(int m) {
        this.m = m;
        return (S)((AbstractElasticsearchVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public S dimension(int dimension) {
        this.dimension = dimension;
        return (S)((AbstractElasticsearchVectorFieldTypeOptionsStep)this.thisAsS());
    }

    public ElasticsearchIndexValueFieldType<F> toIndexFieldType() {
        if (this.dimension == null) {
            throw MappingLog.INSTANCE.nullVectorDimension(this.buildContext.hints().missingVectorDimension(), this.buildContext.getEventContext());
        }
        PropertyMapping mapping = this.builder.mapping();
        boolean resolvedProjectable = AbstractElasticsearchVectorFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = AbstractElasticsearchVectorFieldTypeOptionsStep.resolveDefault(this.searchable);
        mapping.setIndex(resolvedSearchable);
        this.mappingContributor.contribute(mapping, (ElasticsearchVectorFieldTypeMappingContributor.Context)this);
        AbstractElasticsearchVectorFieldCodec<F> codec = this.createCodec(this.vectorSimilarity, this.dimension, this.m, this.efConstruction, this.indexNullAs);
        this.builder.codec(codec);
        if (resolvedSearchable) {
            this.builder.searchable(true);
            this.builder.queryElementFactory(PredicateTypeKeys.EXISTS, new ElasticsearchExistsPredicate.Factory());
        }
        if (resolvedProjectable) {
            this.builder.projectable(true);
            this.builder.queryElementFactory(ProjectionTypeKeys.FIELD, new ElasticsearchFieldProjection.Factory<F>(codec));
        }
        this.builder.multivaluable(false);
        this.mappingContributor.contribute(this.builder, (ElasticsearchVectorFieldTypeMappingContributor.Context)this);
        return this.builder.build();
    }

    protected abstract AbstractElasticsearchVectorFieldCodec<F> createCodec(VectorSimilarity var1, int var2, Integer var3, Integer var4, F var5);

    protected static boolean resolveDefault(Projectable projectable) {
        switch (projectable) {
            case DEFAULT: 
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
        }
        throw new AssertionFailure("Unexpected value for Projectable: " + String.valueOf(projectable));
    }

    protected static boolean resolveDefault(Searchable searchable) {
        switch (searchable) {
            case DEFAULT: 
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
        }
        throw new AssertionFailure("Unexpected value for Searchable: " + String.valueOf(searchable));
    }

    @Override
    public abstract String type();

    @Override
    public boolean searchable() {
        return AbstractElasticsearchVectorFieldTypeOptionsStep.resolveDefault(this.searchable);
    }

    @Override
    public VectorSimilarity vectorSimilarity() {
        return this.vectorSimilarity;
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    @Override
    public Integer efConstruction() {
        return this.efConstruction;
    }

    @Override
    public Integer m() {
        return this.m;
    }
}

