/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.projection.spi;

import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.spi.ListBasedProjectionCollector;

final class SortedSetComparatorProjectionCollector<E, V>
extends ListBasedProjectionCollector<E, V, SortedSet<V>> {
    private final Comparator<? super V> comparator;

    static <U, R> ProjectionCollector.Provider<U, R> provider(Comparator<? super U> comparator) {
        return new ComparatorBasedSortedSetProvider(comparator);
    }

    private SortedSetComparatorProjectionCollector(Comparator<? super V> comparator) {
        this.comparator = comparator;
    }

    @Override
    public SortedSet<V> doFinish(List<V> accumulated) {
        TreeSet<V> set = new TreeSet<V>(this.comparator);
        set.addAll(accumulated);
        return set;
    }

    private static class ComparatorBasedSortedSetProvider<U, R>
    implements ProjectionCollector.Provider<U, R> {
        private final SortedSetComparatorProjectionCollector<?, U> instance;

        private ComparatorBasedSortedSetProvider(Comparator<? super U> comparator) {
            this.instance = new SortedSetComparatorProjectionCollector(comparator);
        }

        @Override
        public <T> ProjectionCollector<T, U, ?, R> get() {
            return this.instance;
        }

        @Override
        public boolean isSingleValued() {
            return false;
        }
    }
}

