/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.web.host.CommonWebServer;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.UndertowListener;
import org.wildfly.extension.undertow.logging.UndertowLogger;

final class WebServerService
implements CommonWebServer,
Service<WebServerService> {
    private final Consumer<WebServerService> serviceConsumer;
    private final Supplier<Server> server;

    WebServerService(Consumer<WebServerService> serviceConsumer, Supplier<Server> server) {
        this.serviceConsumer = serviceConsumer;
        this.server = server;
    }

    public int getPort(String protocol, boolean secure) {
        Map<String, UndertowListener> listeners = this.getListenerMap();
        UndertowListener listener = null;
        for (Map.Entry<String, UndertowListener> entry : listeners.entrySet()) {
            if (!protocol.toLowerCase(Locale.ENGLISH).contains(entry.getKey())) continue;
            listener = entry.getValue();
        }
        if (listener != null && listener.getProtocol() == "http" && secure) {
            if (listeners.containsKey("https")) {
                listener = listeners.get("https");
            } else {
                UndertowLogger.ROOT_LOGGER.secureListenerNotAvailableForPort(protocol);
            }
        }
        if (listener != null) {
            SocketBinding binding = listener.getSocketBinding();
            return binding.getAbsolutePort();
        }
        throw UndertowLogger.ROOT_LOGGER.noPortListeningForProtocol(protocol);
    }

    private Map<String, UndertowListener> getListenerMap() {
        HashMap<String, UndertowListener> listeners = new HashMap<String, UndertowListener>();
        for (UndertowListener listener : this.server.get().getListeners()) {
            listeners.put(listener.getProtocol(), listener);
        }
        return listeners;
    }

    public void start(StartContext context) {
        this.serviceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.serviceConsumer.accept(null);
    }

    public WebServerService getValue() {
        return this;
    }
}

