/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.as.clustering.controller.StatisticsEnabledAttributeDefinition;
import org.jboss.as.clustering.jgroups.JChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.StackOperationHandler;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinitionRegistrar;
import org.jboss.as.clustering.naming.BinderServiceInstaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.dmr.ModelNode;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.ChannelFactoryConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.RelayConfiguration;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.common.function.Functions;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ChildResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.capability.ResourceCapabilityReference;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class StackResourceDefinitionRegistrar
implements ChildResourceDefinitionRegistrar,
ResourceServiceConfigurator {
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ChannelFactory.SERVICE_DESCRIPTOR).setAllowMultipleRegistrations(true).build();
    private static final ResourceOperationRuntimeHandler BINDING_RUNTIME_HANDLER = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)new ResourceServiceConfigurator(){

        public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
            return new BinderServiceInstaller(JGroupsBindingFactory.CHANNEL_FACTORY.apply(context.getCurrentAddressValue()), CAPABILITY.getCapabilityServiceName(context.getCurrentAddress()));
        }
    });
    private static final ResourceCapabilityReference<TransportConfiguration<TP>> TRANSPORT_REFERENCE = ResourceCapabilityReference.builder(CAPABILITY, (UnaryServiceDescriptor)TransportConfiguration.SERVICE_DESCRIPTOR).build();
    static final StatisticsEnabledAttributeDefinition STATISTICS_ENABLED = new StatisticsEnabledAttributeDefinition.Builder().build();

    public ManagementResourceRegistration register(ManagementResourceRegistration parent, ManagementResourceRegistrationContext context) {
        ParentResourceDescriptionResolver resolver = JGroupsSubsystemResourceDefinitionRegistrar.RESOLVER.createChildResolver(JGroupsResourceRegistration.STACK.getPathElement());
        ResourceOperationRuntimeHandler runtimeHandler = ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this);
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)resolver).addAttributes(List.of(STATISTICS_ENABLED))).addCapability(CAPABILITY)).withRuntimeHandler(ResourceOperationRuntimeHandler.combine((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{runtimeHandler, BINDING_RUNTIME_HANDLER}))).addResourceCapabilityReference(TRANSPORT_REFERENCE)).build();
        ManagementResourceRegistration registration = parent.registerSubModel(ResourceDefinition.builder((ResourceRegistration)JGroupsResourceRegistration.STACK, (ResourceDescriptionResolver)resolver).build());
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        if (context.isRuntimeOnlyRegistrationValid()) {
            new StackOperationHandler().register(registration);
        }
        new TransportResourceDefinitionRegistrar(runtimeHandler).register(registration, context);
        new ProtocolResourceDefinitionRegistrar(runtimeHandler).register(registration, context);
        new RelayResourceDefinitionRegistrar(runtimeHandler).register(registration, context);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        final boolean statisticsEnabled = STATISTICS_ENABLED.resolve(context, model);
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        final ServiceDependency transport = (ServiceDependency)TRANSPORT_REFERENCE.resolve(context, resource);
        final ServiceDependency relay = resource.hasChildren(Component.RELAY.getPathElement().getKey()) ? ServiceDependency.on((UnaryServiceDescriptor)RelayConfiguration.SERVICE_DESCRIPTOR, (String)name) : ServiceDependency.empty();
        Set protocolNames = resource.getChildrenNames(Component.PROTOCOL.getPathElement().getKey());
        final ArrayList<ServiceDependency> protocols = new ArrayList<ServiceDependency>(protocolNames.size());
        for (String protocolName : protocolNames) {
            protocols.add(ServiceDependency.on((BinaryServiceDescriptor)ProtocolConfiguration.SERVICE_DESCRIPTOR, (String)name, (String)protocolName));
        }
        final ServiceDependency environment = ServiceDependency.on((NullaryServiceDescriptor)ServerEnvironment.SERVICE_DESCRIPTOR);
        final ServiceDependency socketBindingManager = ServiceDependency.on((NullaryServiceDescriptor)SocketBindingManager.SERVICE_DESCRIPTOR);
        ChannelFactoryConfiguration configuration = new ChannelFactoryConfiguration(){

            public boolean isStatisticsEnabled() {
                return statisticsEnabled;
            }

            public TransportConfiguration<? extends TP> getTransport() {
                return (TransportConfiguration)transport.get();
            }

            public List<ProtocolConfiguration<? extends Protocol>> getProtocols() {
                return protocols.stream().map(Supplier::get).collect(Collectors.toUnmodifiableList());
            }

            public String getMemberName() {
                return ((ServerEnvironment)environment.get()).getNodeName();
            }

            public Optional<RelayConfiguration> getRelay() {
                return Optional.ofNullable((RelayConfiguration)relay.get());
            }

            public SocketBindingManager getSocketBindingManager() {
                return (SocketBindingManager)socketBindingManager.get();
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(CAPABILITY, JChannelFactory::new, (Supplier)Functions.constantSupplier((Object)configuration)).requires(List.of(transport, relay, environment, socketBindingManager))).requires(protocols)).blocking()).build();
    }

    public static enum Component implements ResourceRegistration
    {
        TRANSPORT("transport"),
        PROTOCOL("protocol"),
        RELAY("relay");

        private final PathElement path;

        private Component(String name) {
            this.path = PathElement.pathElement((String)name);
        }

        public PathElement getPathElement() {
            return this.path;
        }

        public PathElement pathElement(String value) {
            return PathElement.pathElement((String)this.getPathElement().getKey(), (String)value);
        }
    }
}

