/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.user;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.wildfly.clustering.cache.CacheEntryMutatorFactory;
import org.wildfly.clustering.function.Supplier;
import org.wildfly.clustering.server.util.BlockingReferenceMap;
import org.wildfly.clustering.session.user.UserSessions;

public class MutableUserSessions<K, D, S>
implements UserSessions<D, S> {
    private final K key;
    private final Map<D, S> sessions;
    private final CacheEntryMutatorFactory<K, Map<D, S>> mutatorFactory;
    private final BlockingReferenceMap<D, S> updates = BlockingReferenceMap.of(new TreeMap());

    public MutableUserSessions(K key, Map<D, S> sessions, CacheEntryMutatorFactory<K, Map<D, S>> mutatorFactory) {
        this.key = key;
        this.sessions = sessions;
        this.mutatorFactory = mutatorFactory;
    }

    public Set<D> getDeployments() {
        return Collections.unmodifiableSet(this.sessions.keySet());
    }

    public S getSession(D deployment) {
        return this.sessions.get(deployment);
    }

    public S removeSession(D deployment) {
        S removed = this.sessions.remove(deployment);
        if (removed != null) {
            this.updates.reference(deployment).writer((java.util.function.Supplier)Supplier.empty()).get();
        }
        return removed;
    }

    public boolean addSession(D deployment, S session) {
        boolean added;
        boolean bl = added = this.sessions.put(deployment, session) == null;
        if (added) {
            this.updates.reference(deployment).writer(session).get();
        }
        return added;
    }

    public void close() {
        this.updates.reader().consume(map -> {
            if (!map.isEmpty()) {
                this.mutatorFactory.createMutator(this.key, map).run();
            }
        });
    }
}

