/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TimeQuantity;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupForBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.xsite.spi.XSiteEntryMergePolicy;

public class SitesConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<SitesConfiguration> {
    private final AttributeSet attributes;
    private final List<BackupConfigurationBuilder> backups = new ArrayList<BackupConfigurationBuilder>(2);
    private final BackupForBuilder backupForBuilder;

    public SitesConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
        this.attributes = SitesConfiguration.attributeDefinitionSet();
        this.backupForBuilder = new BackupForBuilder(builder);
    }

    public BackupConfigurationBuilder addBackup() {
        BackupConfigurationBuilder bcb = new BackupConfigurationBuilder(this.getBuilder());
        this.backups.add(bcb);
        return bcb;
    }

    public List<BackupConfigurationBuilder> backups() {
        return this.backups;
    }

    @Deprecated(forRemoval=true, since="14.0")
    public SitesConfigurationBuilder disableBackups(boolean disable) {
        return this;
    }

    @Deprecated(forRemoval=true, since="14.0")
    public SitesConfigurationBuilder addInUseBackupSite(String site) {
        return this;
    }

    public BackupForBuilder backupFor() {
        return this.backupForBuilder;
    }

    public SitesConfigurationBuilder mergePolicy(XSiteEntryMergePolicy<?, ?> mergePolicy) {
        this.attributes.attribute(SitesConfiguration.MERGE_POLICY).set(mergePolicy);
        return this;
    }

    public SitesConfigurationBuilder maxTombstoneCleanupDelay(long value) {
        this.attributes.attribute(SitesConfiguration.MAX_CLEANUP_DELAY).set((Object)TimeQuantity.valueOf((long)value));
        return this;
    }

    public SitesConfigurationBuilder maxTombstoneCleanupDelay(String value) {
        this.attributes.attribute(SitesConfiguration.MAX_CLEANUP_DELAY).set((Object)TimeQuantity.valueOf((String)value));
        return this;
    }

    public SitesConfigurationBuilder tombstoneMapSize(int value) {
        this.attributes.attribute(SitesConfiguration.TOMBSTONE_MAP_SIZE).set((Object)value);
        return this;
    }

    public void validate() {
        this.backupForBuilder.validate();
        this.attributes.validate();
        HashSet<String> backupNames = new HashSet<String>(this.backups.size());
        for (BackupConfigurationBuilder bcb : this.backups) {
            if (!backupNames.add(bcb.site())) {
                throw Log.CONFIG.multipleSitesWithSameName(bcb.site());
            }
            bcb.validate();
        }
        if (!backupNames.isEmpty() && !this.builder.clustering().cacheMode().isClustered()) {
            throw Log.CONFIG.xsiteInLocalCache();
        }
        if (this.attributes.attribute(SitesConfiguration.MERGE_POLICY).get() == null) {
            throw Log.CONFIG.missingXSiteEntryMergePolicy();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        this.backupForBuilder.validate(globalConfig);
        this.attributes.validate();
        for (BackupConfigurationBuilder bcb : this.backups) {
            bcb.validate(globalConfig);
        }
    }

    public SitesConfiguration create() {
        ArrayList<BackupConfiguration> backupConfigurations = new ArrayList<BackupConfiguration>(this.backups.size());
        for (BackupConfigurationBuilder bcb : this.backups) {
            backupConfigurations.add(bcb.create());
        }
        return new SitesConfiguration(this.attributes.protect(), backupConfigurations, this.backupForBuilder.create());
    }

    public SitesConfigurationBuilder read(SitesConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.backupForBuilder.read(template.backupFor(), combine);
        if (combine.repeatedAttributes() == Combine.RepeatedAttributes.OVERRIDE && template.attributes().isTouched()) {
            this.backups.clear();
        }
        for (BackupConfiguration bc : template.allBackups()) {
            BackupConfigurationBuilder bcb = new BackupConfigurationBuilder(this.getBuilder());
            bcb.read(bc, combine);
            this.backups.removeIf(b -> b.site().equals(bcb.site()));
            this.backups.add(bcb);
        }
        return this;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }
}

