/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.function.Supplier;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.global.GlobalStatePathConfiguration;
import org.infinispan.configuration.global.GlobalStorageConfiguration;
import org.infinispan.configuration.global.TemporaryGlobalStatePathConfiguration;
import org.infinispan.configuration.global.UncleanShutdownAction;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.globalstate.LocalConfigurationStorage;

public class GlobalStateConfiguration {
    public static final AttributeDefinition<Boolean> ENABLED = AttributeDefinition.builder((Enum)Attribute.ENABLED, (Object)false).autoPersist(false).immutable().build();
    public static final AttributeDefinition<UncleanShutdownAction> UNCLEAN_SHUTDOWN_ACTION = AttributeDefinition.builder((Enum)Attribute.UNCLEAN_SHUTDOWN_ACTION, (Object)((Object)UncleanShutdownAction.FAIL)).immutable().build();
    private final AttributeSet attributes;
    private final boolean enabled;
    private final GlobalStatePathConfiguration persistenceLocationConfiguration;
    private final GlobalStatePathConfiguration sharedPersistenceLocationConfiguration;
    private final TemporaryGlobalStatePathConfiguration temporaryLocationConfiguration;
    private final GlobalStorageConfiguration globalStorageConfiguration;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(GlobalStateConfiguration.class, new AttributeDefinition[]{ENABLED, UNCLEAN_SHUTDOWN_ACTION});
    }

    public GlobalStateConfiguration(AttributeSet attributes, GlobalStatePathConfiguration persistenceLocationConfiguration, GlobalStatePathConfiguration sharedPersistenceLocationConfiguration, TemporaryGlobalStatePathConfiguration temporaryLocationConfiguration, GlobalStorageConfiguration globalStorageConfiguration) {
        this.attributes = attributes.checkProtection();
        this.enabled = (Boolean)attributes.attribute(ENABLED).get();
        this.persistenceLocationConfiguration = persistenceLocationConfiguration;
        this.sharedPersistenceLocationConfiguration = sharedPersistenceLocationConfiguration;
        this.temporaryLocationConfiguration = temporaryLocationConfiguration;
        this.globalStorageConfiguration = globalStorageConfiguration;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public UncleanShutdownAction uncleanShutdownAction() {
        return (UncleanShutdownAction)((Object)this.attributes.attribute(UNCLEAN_SHUTDOWN_ACTION).get());
    }

    public String persistentLocation() {
        return this.persistenceLocationConfiguration.getLocation();
    }

    public GlobalStatePathConfiguration persistenceConfiguration() {
        return this.persistenceLocationConfiguration;
    }

    public String sharedPersistentLocation() {
        if (this.sharedPersistenceLocationConfiguration.isModified()) {
            return this.sharedPersistenceLocationConfiguration.getLocation();
        }
        return this.persistentLocation();
    }

    public GlobalStatePathConfiguration sharedPersistenceConfiguration() {
        return this.sharedPersistenceLocationConfiguration;
    }

    public String temporaryLocation() {
        return this.temporaryLocationConfiguration.getLocation();
    }

    public TemporaryGlobalStatePathConfiguration temporaryLocationConfiguration() {
        return this.temporaryLocationConfiguration;
    }

    public ConfigurationStorage configurationStorage() {
        return this.globalStorageConfiguration.configurationStorage();
    }

    public GlobalStorageConfiguration globalStorageConfiguration() {
        return this.globalStorageConfiguration;
    }

    public Supplier<? extends LocalConfigurationStorage> configurationStorageClass() {
        return this.globalStorageConfiguration.storageSupplier();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String toString() {
        return "GlobalStateConfiguration [attributes=" + String.valueOf(this.attributes) + "]";
    }
}

