/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;

public final class WSDependenciesProcessor
implements DeploymentUnitProcessor {
    private static final String JBOSSWS_API = "org.jboss.ws.api";
    private static final String JBOSSWS_SPI = "org.jboss.ws.spi";
    private static final String[] JAVAEE_APIS = new String[]{"jakarta.xml.ws.api", "jakarta.xml.soap.api"};
    private final boolean addJBossWSDependencies;

    public WSDependenciesProcessor(boolean addJBossWSDependencies) {
        this.addJBossWSDependencies = addJBossWSDependencies;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpec = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (this.addJBossWSDependencies) {
            moduleSpec.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)JBOSSWS_API).setExport(true).setImportServices(true).build());
            moduleSpec.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)JBOSSWS_SPI).setExport(true).setImportServices(true).build());
        }
        for (String api : JAVAEE_APIS) {
            moduleSpec.addSystemDependency(ModuleDependency.Builder.of((ModuleLoader)moduleLoader, (String)api).setImportServices(true).build());
        }
    }
}

