/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.threads.HandoffExecutorResolver;
import org.jboss.as.threads.KeepAliveTimeAttributeDefinition;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadFactoryResolver;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.as.threads.TimeSpec;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

class ThreadPoolManagementUtils {
    ThreadPoolManagementUtils() {
    }

    static <T> void installThreadPoolService(Service<T> threadPoolService, String threadPoolName, RuntimeCapability<Void> cap, PathAddress address, ServiceName serviceNameBase, String threadFactoryName, ThreadFactoryResolver threadFactoryResolver, Injector<ThreadFactory> threadFactoryInjector, String handoffExecutorName, HandoffExecutorResolver handoffExecutorResolver, Injector<Executor> handoffExecutorInjector, ServiceTarget target) {
        ServiceName handoffServiceName;
        ServiceName aliasServiceName;
        ServiceName threadPoolServiceName;
        if (cap != null) {
            threadPoolServiceName = cap.getCapabilityServiceName(address);
            aliasServiceName = serviceNameBase != null ? serviceNameBase.append(new String[]{threadPoolName}) : null;
        } else {
            threadPoolServiceName = serviceNameBase.append(new String[]{threadPoolName});
            aliasServiceName = null;
        }
        ServiceBuilder serviceBuilder = target.addService(threadPoolServiceName, threadPoolService);
        if (aliasServiceName != null) {
            serviceBuilder.addAliases(new ServiceName[]{aliasServiceName});
        }
        ServiceName threadFactoryServiceName = threadFactoryResolver.resolveThreadFactory(threadFactoryName, threadPoolName, threadPoolServiceName, target);
        serviceBuilder.addDependency(threadFactoryServiceName, ThreadFactory.class, threadFactoryInjector);
        if (handoffExecutorInjector != null && (handoffServiceName = handoffExecutorResolver.resolveHandoffExecutor(handoffExecutorName, threadPoolName, threadPoolServiceName, target)) != null) {
            serviceBuilder.addDependency(handoffServiceName, Executor.class, handoffExecutorInjector);
        }
        serviceBuilder.install();
    }

    static void removeThreadPoolService(String threadPoolName, RuntimeCapability<Void> cap, ServiceName serviceNameBase, String threadFactoryName, ThreadFactoryResolver threadFactoryResolver, OperationContext operationContext) {
        ThreadPoolManagementUtils.removeThreadPoolService(threadPoolName, cap, serviceNameBase, threadFactoryName, threadFactoryResolver, null, null, operationContext);
    }

    static void removeThreadPoolService(String threadPoolName, ServiceName serviceNameBase, String threadFactoryName, ThreadFactoryResolver threadFactoryResolver, String handoffExecutorName, HandoffExecutorResolver handoffExecutorResolver, OperationContext operationContext) {
        ThreadPoolManagementUtils.removeThreadPoolService(threadPoolName, null, serviceNameBase, threadFactoryName, threadFactoryResolver, handoffExecutorName, handoffExecutorResolver, operationContext);
    }

    public static void removeThreadPoolService(String threadPoolName, RuntimeCapability<Void> cap, ServiceName serviceNameBase, String threadFactoryName, ThreadFactoryResolver threadFactoryResolver, String handoffExecutorName, HandoffExecutorResolver handoffExecutorResolver, OperationContext operationContext) {
        ServiceName threadPoolServiceName = cap != null ? cap.getCapabilityServiceName(new String[]{threadPoolName}) : serviceNameBase.append(new String[]{threadPoolName});
        operationContext.removeService(threadPoolServiceName);
        threadFactoryResolver.releaseThreadFactory(threadFactoryName, threadPoolName, threadPoolServiceName, operationContext);
        if (handoffExecutorResolver != null) {
            handoffExecutorResolver.releaseHandoffExecutor(handoffExecutorName, threadPoolName, threadPoolServiceName, operationContext);
        }
    }

    static BaseThreadPoolParameters parseUnboundedQueueThreadPoolParameters(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ThreadPoolParametersImpl params = new ThreadPoolParametersImpl();
        return ThreadPoolManagementUtils.parseBaseThreadPoolOperationParameters(context, operation, model, params);
    }

    static EnhancedQueueThreadPoolParameters parseEnhancedQueueThreadPoolParameters(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ThreadPoolParametersImpl params = new ThreadPoolParametersImpl();
        ThreadPoolManagementUtils.parseBaseThreadPoolOperationParameters(context, operation, model, params);
        ModelNode coreTh = PoolAttributeDefinitions.CORE_THREADS.resolveModelAttribute(context, model);
        params.coreThreads = coreTh.isDefined() ? coreTh.asInt() : params.maxThreads;
        return params;
    }

    static BaseThreadPoolParameters parseScheduledThreadPoolParameters(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ThreadPoolParametersImpl params = new ThreadPoolParametersImpl();
        return ThreadPoolManagementUtils.parseBaseThreadPoolOperationParameters(context, operation, model, params);
    }

    static EnhancedQueueThreadPoolParameters parseQueuelessThreadPoolParameters(OperationContext context, ModelNode operation, ModelNode model, boolean blocking) throws OperationFailedException {
        ThreadPoolParametersImpl params = new ThreadPoolParametersImpl();
        ThreadPoolManagementUtils.parseBaseThreadPoolOperationParameters(context, operation, model, params);
        if (!blocking) {
            ModelNode handoffEx = PoolAttributeDefinitions.HANDOFF_EXECUTOR.resolveModelAttribute(context, model);
            params.handoffExecutor = handoffEx.isDefined() ? handoffEx.asString() : null;
        }
        return params;
    }

    static EnhancedQueueThreadPoolParameters parseBoundedThreadPoolParameters(OperationContext context, ModelNode operation, ModelNode model, boolean blocking) throws OperationFailedException {
        ModelNode coreTh;
        ThreadPoolParametersImpl params = new ThreadPoolParametersImpl();
        ThreadPoolManagementUtils.parseBaseThreadPoolOperationParameters(context, operation, model, params);
        params.allowCoreTimeout = PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT.resolveModelAttribute(context, model).asBoolean();
        if (!blocking) {
            ModelNode handoffEx = PoolAttributeDefinitions.HANDOFF_EXECUTOR.resolveModelAttribute(context, model);
            params.handoffExecutor = handoffEx.isDefined() ? handoffEx.asString() : null;
        }
        params.coreThreads = (coreTh = PoolAttributeDefinitions.CORE_THREADS.resolveModelAttribute(context, model)).isDefined() ? coreTh.asInt() : params.maxThreads;
        params.queueLength = PoolAttributeDefinitions.QUEUE_LENGTH.resolveModelAttribute(context, model).asInt();
        return params;
    }

    private static ThreadPoolParametersImpl parseBaseThreadPoolOperationParameters(OperationContext context, ModelNode operation, ModelNode model, ThreadPoolParametersImpl params) throws OperationFailedException {
        params.address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)params.address);
        params.name = pathAddress.getLastElement().getValue();
        ModelNode tfNode = PoolAttributeDefinitions.THREAD_FACTORY.resolveModelAttribute(context, model);
        params.threadFactory = tfNode.isDefined() ? tfNode.asString() : null;
        params.maxThreads = PoolAttributeDefinitions.MAX_THREADS.resolveModelAttribute(context, model).asInt();
        if (model.hasDefined("keepalive-time")) {
            ModelNode keepaliveTime = model.get("keepalive-time");
            if (!keepaliveTime.hasDefined("time")) {
                throw ThreadsLogger.ROOT_LOGGER.missingKeepAliveTime("time", "keepalive-time");
            }
            if (!keepaliveTime.hasDefined("unit")) {
                throw ThreadsLogger.ROOT_LOGGER.missingKeepAliveUnit("unit", "keepalive-time");
            }
            long time = KeepAliveTimeAttributeDefinition.KEEPALIVE_TIME_TIME.resolveModelAttribute(context, keepaliveTime).asLong();
            String unit = KeepAliveTimeAttributeDefinition.KEEPALIVE_TIME_UNIT.resolveModelAttribute(context, keepaliveTime).asString();
            params.keepAliveTime = new TimeSpec(Enum.valueOf(TimeUnit.class, unit.toUpperCase(Locale.ENGLISH)), time);
        }
        return params;
    }

    private static class ThreadPoolParametersImpl
    implements EnhancedQueueThreadPoolParameters {
        ModelNode address;
        String name;
        String threadFactory;
        int maxThreads;
        TimeSpec keepAliveTime;
        String handoffExecutor;
        boolean allowCoreTimeout;
        int coreThreads;
        int queueLength;

        private ThreadPoolParametersImpl() {
        }

        @Override
        public ModelNode getAddress() {
            return this.address;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getThreadFactory() {
            return this.threadFactory;
        }

        @Override
        public int getMaxThreads() {
            return this.maxThreads;
        }

        @Override
        public TimeSpec getKeepAliveTime() {
            return this.keepAliveTime;
        }

        @Override
        public String getHandoffExecutor() {
            return this.handoffExecutor;
        }

        @Override
        public boolean isAllowCoreTimeout() {
            return this.allowCoreTimeout;
        }

        @Override
        public int getCoreThreads() {
            return this.coreThreads;
        }

        @Override
        public int getQueueLength() {
            return this.queueLength;
        }
    }

    static interface EnhancedQueueThreadPoolParameters
    extends BaseThreadPoolParameters {
        public int getCoreThreads();

        public boolean isAllowCoreTimeout();

        public int getQueueLength();

        public String getHandoffExecutor();
    }

    static interface BaseThreadPoolParameters {
        public ModelNode getAddress();

        public String getName();

        public String getThreadFactory();

        public int getMaxThreads();

        public TimeSpec getKeepAliveTime();
    }
}

