/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import jakarta.resource.spi.ConnectionRequestInfo;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.apache.activemq.artemis.ra.ActiveMQRAProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQRAConnectionRequestInfo
implements ConnectionRequestInfo {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String userName;
    private String password;
    private String clientID;
    private final int type;
    private final boolean transacted;
    private final int acknowledgeMode;

    public ActiveMQRAConnectionRequestInfo(ActiveMQRAProperties prop, int type) {
        logger.trace("constructor({})", (Object)prop);
        this.userName = prop.getUserName();
        this.password = prop.getPassword();
        this.clientID = prop.getClientID();
        this.type = type;
        this.transacted = true;
        this.acknowledgeMode = 1;
    }

    public ActiveMQRAConnectionRequestInfo(boolean transacted, int acknowledgeMode, int type) {
        if (logger.isTraceEnabled()) {
            logger.trace("constructor({}, {}, {})", new Object[]{transacted, acknowledgeMode, type});
        }
        this.transacted = transacted;
        this.acknowledgeMode = acknowledgeMode;
        this.type = type;
    }

    public void setDefaults(ActiveMQRAProperties prop) {
        logger.trace("setDefaults({})", (Object)prop);
        if (this.userName == null) {
            this.userName = prop.getUserName();
        }
        if (this.password == null) {
            this.password = prop.getPassword();
        }
        if (this.clientID == null) {
            this.clientID = prop.getClientID();
        }
    }

    public String getUserName() {
        logger.trace("getUserName()");
        return this.userName;
    }

    public void setUserName(String userName) {
        logger.trace("setUserName({})", (Object)userName);
        this.userName = userName;
    }

    public String getPassword() {
        logger.trace("getPassword()");
        return this.password;
    }

    public void setPassword(String password) {
        logger.trace("setPassword(****)");
        this.password = password;
    }

    public String getClientID() {
        logger.trace("getClientID()");
        return this.clientID;
    }

    public void setClientID(String clientID) {
        logger.trace("setClientID({})", (Object)clientID);
        this.clientID = clientID;
    }

    public int getType() {
        logger.trace("getType()");
        return this.type;
    }

    public boolean isTransacted() {
        if (logger.isTraceEnabled()) {
            logger.trace("isTransacted() {}", (Object)this.transacted);
        }
        return this.transacted;
    }

    public int getAcknowledgeMode() {
        logger.trace("getAcknowledgeMode()");
        return this.acknowledgeMode;
    }

    public boolean equals(Object obj) {
        logger.trace("equals({})", obj);
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ActiveMQRAConnectionRequestInfo)) {
            return false;
        }
        ActiveMQRAConnectionRequestInfo requestInfo = (ActiveMQRAConnectionRequestInfo)obj;
        return Objects.equals(this.userName, requestInfo.getUserName()) && Objects.equals(this.password, requestInfo.getPassword()) && Objects.equals(this.clientID, requestInfo.getClientID()) && this.type == requestInfo.getType() && this.transacted == requestInfo.isTransacted() && this.acknowledgeMode == requestInfo.getAcknowledgeMode();
    }

    public int hashCode() {
        logger.trace("hashCode()");
        return Objects.hash(this.userName, this.password, this.type, this.transacted, this.acknowledgeMode);
    }

    public String toString() {
        return "ActiveMQRAConnectionRequestInfo[type=" + this.type + ", transacted=" + this.transacted + ", acknowledgeMode=" + this.acknowledgeMode + ", clientID=" + this.clientID + ", userName=" + this.userName + ", password=****]";
    }
}

