/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.web;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.SubsystemResourceRegistration;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ParentResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.SubsystemResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllSchema;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.web.service.session.DistributableSessionManagementProvider;
import org.wildfly.clustering.web.service.user.DistributableUserManagementProvider;
import org.wildfly.extension.clustering.web.HotRodSessionManagementResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.web.HotRodUserManagementResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.web.InfinispanRoutingProviderResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.web.InfinispanSessionManagementResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.web.InfinispanUserManagementResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.web.LocalRoutingProviderResourceDefinitionRegistrar;
import org.wildfly.extension.clustering.web.RoutingProviderResourceRegistration;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentDependencyProcessor;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentParsingProcessor;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentProcessor;
import org.wildfly.extension.clustering.web.deployment.DistributableWebDeploymentSchema;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ManagementResourceRegistrar;
import org.wildfly.subsystem.resource.ManagementResourceRegistrationContext;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.SubsystemResourceDefinitionRegistrar;
import org.wildfly.subsystem.resource.capability.CapabilityReference;
import org.wildfly.subsystem.resource.capability.CapabilityReferenceAttributeDefinition;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class DistributableWebSubsystemResourceDefinitionRegistrar
implements SubsystemResourceDefinitionRegistrar,
ResourceServiceConfigurator,
Consumer<DeploymentProcessorTarget> {
    static final SubsystemResourceRegistration REGISTRATION = SubsystemResourceRegistration.of((String)"distributable-web");
    static final ParentResourceDescriptionResolver RESOLVER = new SubsystemResourceDescriptionResolver(REGISTRATION.getName(), DistributableWebSubsystemResourceDefinitionRegistrar.class);
    static final RuntimeCapability<Void> DEFAULT_SESSION_MANAGEMENT_PROVIDER = RuntimeCapability.Builder.of((NullaryServiceDescriptor)DistributableSessionManagementProvider.DEFAULT_SERVICE_DESCRIPTOR).build();
    static final RuntimeCapability<Void> DEFAULT_USER_MANAGEMENT_PROVIDER = RuntimeCapability.Builder.of((NullaryServiceDescriptor)DistributableUserManagementProvider.DEFAULT_SERVICE_DESCRIPTOR).build();
    static final CapabilityReferenceAttributeDefinition<DistributableSessionManagementProvider> DEFAULT_SESSION_MANAGEMENT = ((CapabilityReferenceAttributeDefinition.Builder)new CapabilityReferenceAttributeDefinition.Builder("default-session-management", CapabilityReference.builder(DEFAULT_SESSION_MANAGEMENT_PROVIDER, (UnaryServiceDescriptor)DistributableSessionManagementProvider.SERVICE_DESCRIPTOR).build()).setXmlName("default")).build();
    static final CapabilityReferenceAttributeDefinition<DistributableUserManagementProvider> DEFAULT_USER_MANAGEMENT = ((CapabilityReferenceAttributeDefinition.Builder)new CapabilityReferenceAttributeDefinition.Builder("default-single-sign-on-management", CapabilityReference.builder(DEFAULT_USER_MANAGEMENT_PROVIDER, (UnaryServiceDescriptor)DistributableUserManagementProvider.SERVICE_DESCRIPTOR).build()).setXmlName("default")).build();

    public ManagementResourceRegistration register(SubsystemRegistration parent, ManagementResourceRegistrationContext context) {
        ManagementResourceRegistration registration = parent.registerSubsystemModel(ResourceDefinition.builder((ResourceRegistration)REGISTRATION, (ResourceDescriptionResolver)RESOLVER).build());
        ResourceDescriptor descriptor = ((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)((ResourceDescriptor.Builder)ResourceDescriptor.builder((ResourceDescriptionResolver)RESOLVER).addAttributes(List.of(DEFAULT_SESSION_MANAGEMENT, DEFAULT_USER_MANAGEMENT))).addCapabilities(List.of(DEFAULT_SESSION_MANAGEMENT_PROVIDER, DEFAULT_USER_MANAGEMENT_PROVIDER))).requireSingletonChildResource((ResourceRegistration)RoutingProviderResourceRegistration.LOCAL)).withRuntimeHandler(ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this))).withDeploymentChainContributor((Consumer)this)).build();
        ManagementResourceRegistrar.of((ResourceDescriptor)descriptor).register(registration);
        new InfinispanSessionManagementResourceDefinitionRegistrar().register(registration, context);
        new HotRodSessionManagementResourceDefinitionRegistrar().register(registration, context);
        new InfinispanUserManagementResourceDefinitionRegistrar().register(registration, context);
        new HotRodUserManagementResourceDefinitionRegistrar().register(registration, context);
        new LocalRoutingProviderResourceDefinitionRegistrar().register(registration, context);
        new InfinispanRoutingProviderResourceDefinitionRegistrar().register(registration, context);
        return registration;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        CapabilityServiceInstaller defaultSessionManagementInstaller = (CapabilityServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_SESSION_MANAGEMENT_PROVIDER, (ServiceDependency)DEFAULT_SESSION_MANAGEMENT.resolve(context, model)).build();
        CapabilityServiceInstaller defaultUserManagementInstaller = (CapabilityServiceInstaller)CapabilityServiceInstaller.builder(DEFAULT_USER_MANAGEMENT_PROVIDER, (ServiceDependency)DEFAULT_USER_MANAGEMENT.resolve(context, model)).build();
        return ResourceServiceInstaller.combine((ResourceServiceInstaller[])new ResourceServiceInstaller[]{defaultSessionManagementInstaller, defaultUserManagementInstaller});
    }

    @Override
    public void accept(DeploymentProcessorTarget target) {
        target.addDeploymentProcessor(REGISTRATION.getName(), Phase.STRUCTURE, 2589, JBossAllSchema.createDeploymentUnitProcessor(EnumSet.allOf(DistributableWebDeploymentSchema.class), DistributableWebDeploymentDependencyProcessor.CONFIGURATION_KEY));
        target.addDeploymentProcessor(REGISTRATION.getName(), Phase.PARSE, 19201, (DeploymentUnitProcessor)new DistributableWebDeploymentParsingProcessor());
        target.addDeploymentProcessor(REGISTRATION.getName(), Phase.DEPENDENCIES, 288, (DeploymentUnitProcessor)new DistributableWebDeploymentDependencyProcessor());
        target.addDeploymentProcessor(REGISTRATION.getName(), Phase.CONFIGURE_MODULE, 400, (DeploymentUnitProcessor)new DistributableWebDeploymentProcessor());
    }
}

