/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Set;
import org.hibernate.search.engine.cfg.spi.ConfigurationProvider;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@CategorizedLogger(category="org.hibernate.search.configuration", description="Logs related to Hibernate Search configuration in general.\n")
@MessageLogger(projectCode="HSEARCH")
public interface ConfigurationLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.configuration";
    public static final ConfigurationLog INSTANCE = (ConfigurationLog)LoggerFactory.make(ConfigurationLog.class, (String)"org.hibernate.search.configuration", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=501, value="Invalid value for configuration property '%1$s': '%2$s'. %3$s")
    public SearchException unableToConvertConfigurationProperty(String var1, Object var2, String var3, @Cause Exception var4);

    @Message(id=533, value="No backend with name '%1$s'. Check that at least one entity is configured to target that backend. The following backends can be retrieved by name: %2$s. %3$s")
    public SearchException unknownNameForBackend(String var1, Collection<String> var2, String var3);

    @Message(id=534, value="No index manager with name '%1$s'. Check that at least one entity is configured to target that index. The following indexes can be retrieved by name: %2$s.")
    public SearchException unknownNameForIndexManager(String var1, Collection<String> var2);

    @Message(id=566, value="Invalid configuration property checking strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidConfigurationPropertyCheckingStrategyName(String var1, List<String> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=567, value="Configuration property tracking is disabled; unused properties will not be logged.")
    public void configurationPropertyTrackingDisabled();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=568, value="Invalid configuration passed to Hibernate Search: some properties in the given configuration are not used. There might be misspelled property keys in your configuration. Unused properties: %1$s. To disable this warning, set the property '%2$s' to '%3$s'.")
    public void configurationPropertyTrackingUnusedProperties(Set<String> var1, String var2, String var3);

    @Message(id=573, value="Invalid configuration passed to Hibernate Search: some properties in the given configuration are obsolete.Configuration properties changed between Hibernate Search 5 and Hibernate Search 6 Check out the reference documentation and upgrade your configuration. Obsolete properties: %1$s.")
    public SearchException obsoleteConfigurationPropertiesFromSearch5(Set<String> var1);

    @Message(id=575, value="No default backend. Check that at least one entity is configured to target the default backend. The following backends can be retrieved by name: %1$s.")
    public SearchException noDefaultBackendRegistered(Collection<String> var1);

    @Message(id=581, value="Unable to resolve backend type: configuration property '%1$s' is not set, and there isn't any backend in the classpath. Check that you added the desired backend to your project's dependencies.")
    public SearchException noBackendFactoryRegistered(String var1);

    @Message(id=582, value="Ambiguous backend type: configuration property '%1$s' is not set, and multiple backend types are present in the classpath. Set property '%1$s' to one of the following to select the backend type: %2$s")
    public SearchException multipleBackendFactoriesRegistered(String var1, Collection<String> var2);

    @Message(id=596, value="Different mappings trying to define two backends with the same name '%1$s' but having different expectations on multi-tenancy.")
    public SearchException differentMultiTenancyNamedBackend(String var1);

    @Message(id=597, value="Different mappings trying to define default backends having different expectations on multi-tenancy.")
    public SearchException differentMultiTenancyDefaultBackend();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=616, value="Ignoring ServiceConfigurationError caught while trying to instantiate service '%s'.")
    public void ignoringServiceConfigurationError(Class<?> var1, @Cause ServiceConfigurationError var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=620, value="Multiple configuration providers are available for scope '%1$s'. They will be taken under consideration in the following order: '%2$s'.")
    public void multipleConfigurationProvidersAvailable(String var1, List<ConfigurationProvider> var2);
}

