/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Locale;
import org.hibernate.search.engine.logging.impl.QueryLog;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.common.RewriteMethod;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextNoPrefixFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.Logger;

public class QueryLog_$logger
implements QueryLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = QueryLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public QueryLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String rangePredicateCannotMatchNullValue$str() {
        return "HSEARCH000237: Invalid range: at least one bound in range predicates must be non-null.";
    }

    @Override
    public final SearchException rangePredicateCannotMatchNullValue(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangePredicateCannotMatchNullValue$str(), new Object[0]), context);
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String perFieldBoostWithConstantScore$str() {
        return "HSEARCH000551: Invalid use of per-field boost: the predicate score is constant. Cannot assign a different boost to each field when the predicate score is constant.";
    }

    @Override
    public final SearchException perFieldBoostWithConstantScore() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.perFieldBoostWithConstantScore$str(), new Object[0]));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPhrasePredicateSlop$str() {
        return "HSEARCH000553: Invalid slop: %1$d. The slop must be positive or zero.";
    }

    @Override
    public final SearchException invalidPhrasePredicateSlop(int slop) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidPhrasePredicateSlop$str(), slop));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidFuzzyMaximumEditDistance$str() {
        return "HSEARCH000554: Invalid maximum edit distance: %1$d. The value must be 0, 1 or 2.";
    }

    @Override
    public final SearchException invalidFuzzyMaximumEditDistance(int maximumEditDistance) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFuzzyMaximumEditDistance$str(), maximumEditDistance));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidExactPrefixLength$str() {
        return "HSEARCH000555: Invalid exact prefix length: %1$d. The value must be positive or zero.";
    }

    @Override
    public final SearchException invalidExactPrefixLength(int exactPrefixLength) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidExactPrefixLength$str(), exactPrefixLength));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonSingleHit$str() {
        return "HSEARCH000561: Multiple hits when a single hit was expected.";
    }

    @Override
    public final SearchException nonSingleHit() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonSingleHit$str(), new Object[0]));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownAggregationKey$str() {
        return "HSEARCH000565: Unknown aggregation key '%1$s'. This key was not used when building the search query.";
    }

    @Override
    public final SearchException unknownAggregationKey(AggregationKey<?> key) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownAggregationKey$str(), key));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedMultiValuedField$str() {
        return "HSEARCH000572: Inconsistent index data: a supposedly single-valued field returned multiple values. Values: [%1$s, %2$s].";
    }

    @Override
    public final SearchException unexpectedMultiValuedField(Object value1, Object value2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedMultiValuedField$str(), value1, value2));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidDslArgumentType$str() {
        return "HSEARCH000583: Invalid type for DSL arguments: '%1$s'. Expected '%2$s' or a subtype.";
    }

    @Override
    public final SearchException invalidDslArgumentType(Class<?> type, Class<?> correctType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidDslArgumentType$str(), new ClassFormatter(type), new ClassFormatter(correctType)), context);
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidReturnType$str() {
        return "HSEARCH000584: Invalid type for returned values: '%1$s'. Expected '%2$s' or a supertype.";
    }

    @Override
    public final SearchException invalidReturnType(Class<?> type, Class<?> correctType, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidReturnType$str(), new ClassFormatter(type), new ClassFormatter(correctType)), context);
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String timedOut$str() {
        return "HSEARCH000586: Operation exceeded the timeout of %1$s.";
    }

    @Override
    public final SearchTimeoutException timedOut(Duration timeout, Exception cause) {
        SearchTimeoutException result = new SearchTimeoutException(String.format(this.getLoggingLocale(), this.timedOut$str(), new DurationInSecondsAndFractionsFormatter(timeout)), (Throwable)cause);
        QueryLog_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String notExactTotalHitCount$str() {
        return "HSEARCH000587: Unable to provide the exact total hit count: only a lower-bound approximation is available. This is generally the result of setting query options such as a timeout or the total hit count threshold. Either unset these options, or retrieve the lower-bound hit count approximation through '.total().hitCountLowerBound()'.";
    }

    @Override
    public final SearchException notExactTotalHitCount() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.notExactTotalHitCount$str(), new Object[0]));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String inconsistentConfigurationInContextForSearch$str() {
        return "HSEARCH000601: Inconsistent configuration for %1$s in a search query across multiple indexes: %2$s";
    }

    @Override
    public final SearchException inconsistentConfigurationInContextForSearch(EventContext elementContext, String causeMessage, EventContext elementContextAsParam, SearchException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.inconsistentConfigurationInContextForSearch$str(), new EventContextNoPrefixFormatter(elementContext), causeMessage), (Throwable)cause, elementContextAsParam);
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String inconsistentSupportForQueryElement$str() {
        return "HSEARCH000602: Inconsistent support for '%1$s': %2$s";
    }

    @Override
    public final SearchException inconsistentSupportForQueryElement(SearchQueryElementTypeKey<?> key, String causeMessage, SearchException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.inconsistentSupportForQueryElement$str(), key, causeMessage), (Throwable)cause);
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String differentAttribute$str() {
        return "HSEARCH000603: Attribute '%1$s' differs: '%2$s' vs. '%3$s'.";
    }

    @Override
    public final SearchException differentAttribute(String attributeName, Object component1, Object component2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.differentAttribute$str(), attributeName, component1, component2));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotUseQueryElementForIndexNode$str() {
        return "HSEARCH000604: Cannot use '%2$s' on %1$s: %3$s";
    }

    @Override
    public final SearchException cannotUseQueryElementForIndexNode(EventContext elementContext, SearchQueryElementTypeKey<?> key, String hint, EventContext context, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotUseQueryElementForIndexNode$str(), new EventContextNoPrefixFormatter(elementContext), key, hint), (Throwable)cause, context);
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String partialSupportForQueryElement$str() {
        return "HSEARCH000606: '%1$s' can be used in some of the targeted indexes, but not all of them. %2$s";
    }

    @Override
    public final SearchException partialSupportForQueryElement(SearchQueryElementTypeKey<?> key, String hint) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.partialSupportForQueryElement$str(), key, hint));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingFieldModel$str() {
        return "HSEARCH000609: This field is a value field in some indexes, but an object field in other indexes.";
    }

    @Override
    public final SearchException conflictingFieldModel() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingFieldModel$str(), new Object[0]));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownFieldForSearch$str() {
        return "HSEARCH000610: Unknown field '%1$s'.";
    }

    @Override
    public final SearchException unknownFieldForSearch(String absoluteFieldPath, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unknownFieldForSearch$str(), absoluteFieldPath), context);
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String targetFieldsSpanningMultipleNestedPaths$str() {
        return "HSEARCH000611: Invalid target fields: fields [%1$s, %3$s] are in different nested documents (%2$s vs. %4$s). All target fields must be in the same document.";
    }

    @Override
    public final SearchException targetFieldsSpanningMultipleNestedPaths(String fieldPath1, EventContext nestedPath1, String fieldPath2, EventContext nestedPath2) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.targetFieldsSpanningMultipleNestedPaths$str(), fieldPath1, new EventContextNoPrefixFormatter(nestedPath1), fieldPath2, new EventContextNoPrefixFormatter(nestedPath2)));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotCreateEntityProjection$str() {
        return "HSEARCH000614: Cannot project on entity type '%1$s': this type cannot be loaded from an external datasource, and the documents from the index cannot be projected to its Java class '%2$s'. %3$s";
    }

    @Override
    public final SearchException cannotCreateEntityProjection(String name, Class<?> javaClass, String hint) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCreateEntityProjection$str(), name, new ClassFormatter(javaClass), hint));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidTypeForEntityProjection$str() {
        return "HSEARCH000618: Invalid type for entity projection on type '%1$s': the entity type's Java class '%2$s' does not extend the requested projection type '%3$s'.";
    }

    @Override
    public final SearchException invalidTypeForEntityProjection(String name, Class<?> entityType, Class<?> requestedEntityType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidTypeForEntityProjection$str(), name, new ClassFormatter(entityType), new ClassFormatter(requestedEntityType)));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String parameterizedRewriteMethodWithoutParameter$str() {
        return "HSEARCH000621: Cannot use rewrite method '%1$s': this method requires parameter 'n', which was not specified. Use another version of the rewrite(...) method that accepts parameter 'n'.";
    }

    @Override
    public final SearchException parameterizedRewriteMethodWithoutParameter(RewriteMethod rewriteMethod) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.parameterizedRewriteMethodWithoutParameter$str(), new Object[]{rewriteMethod}));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonParameterizedRewriteMethodWithParameter$str() {
        return "HSEARCH000622: Cannot use rewrite method '%1$s': this method does not accept parameter 'n', but it was specified. Use another version of the rewrite(...) method that does not accept parameter 'n'.";
    }

    @Override
    public final SearchException nonParameterizedRewriteMethodWithParameter(RewriteMethod rewriteMethod) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonParameterizedRewriteMethodWithParameter$str(), new Object[]{rewriteMethod}));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotFindQueryParameter$str() {
        return "HSEARCH000624: Query parameter '%1$s' is not set. Use `.param(..)` methods on the query to set any parameters that the query requires.";
    }

    @Override
    public final SearchException cannotFindQueryParameter(String parameter) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotFindQueryParameter$str(), parameter));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unexpectedQueryParameterType$str() {
        return "HSEARCH000625: Expecting value of query parameter '%1$s' to be of type %2$s, but instead got a value of type %3$s.";
    }

    @Override
    public final SearchException unexpectedQueryParameterType(String name, Class<?> expected, Class<?> actual) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unexpectedQueryParameterType$str(), name, new ClassFormatter(expected), new ClassFormatter(actual)));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String namedValuesParameterNotDefined$str() {
        return "HSEARCH000626: Named value '%1$s' has not been defined.";
    }

    @Override
    public final SearchException namedValuesParameterNotDefined(String name) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.namedValuesParameterNotDefined$str(), name));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String namedValuesParameterIncorrectType$str() {
        return "HSEARCH000627: Expecting value of named value '%1$s' to be of type %2$s, but instead got a value of type %3$s.";
    }

    @Override
    public final SearchException namedValuesParameterIncorrectType(String name, Class<?> expected, Class<?> actual) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.namedValuesParameterIncorrectType$str(), name, new ClassFormatter(expected), new ClassFormatter(actual)));
        QueryLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

