/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.sort.dsl.impl;

import java.util.function.Function;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.TypedSearchPredicateFactory;
import org.hibernate.search.engine.search.reference.sort.FieldSortFieldReference;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.FieldSortMissingValueBehaviorGenericStep;
import org.hibernate.search.engine.search.sort.dsl.FieldSortMissingValueBehaviorStep;
import org.hibernate.search.engine.search.sort.dsl.FieldSortOptionsGenericStep;
import org.hibernate.search.engine.search.sort.dsl.FieldSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.engine.search.sort.dsl.spi.AbstractSortThenStep;
import org.hibernate.search.engine.search.sort.dsl.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.sort.spi.FieldSortBuilder;
import org.hibernate.search.engine.search.sort.spi.SearchSortIndexScope;
import org.hibernate.search.engine.search.sort.spi.SortTypeKeys;

public abstract class AbstractFieldSortOptionsGenericStep<SR, T, PDF extends TypedSearchPredicateFactory<SR>, S extends AbstractFieldSortOptionsGenericStep<SR, T, PDF, S, N>, N extends FieldSortMissingValueBehaviorGenericStep<T, S>>
extends AbstractSortThenStep<SR>
implements FieldSortOptionsGenericStep<SR, T, S, N, PDF> {
    private final SearchSortDslContext<SR, ?, ? extends PDF> dslContext;
    protected final FieldSortBuilder builder;

    public AbstractFieldSortOptionsGenericStep(SearchSortDslContext<SR, ?, ? extends PDF> dslContext, String fieldPath) {
        super(dslContext);
        this.dslContext = dslContext;
        this.builder = dslContext.scope().fieldQueryElement(fieldPath, SortTypeKeys.FIELD);
    }

    public static <T, SR, SC extends SearchSortIndexScope<?>, PDF extends TypedSearchPredicateFactory<SR>> FieldSortOptionsGenericStep<SR, T, ?, ?, ? extends TypedSearchPredicateFactory<SR>> create(SearchSortDslContext<SR, SC, PDF> dslContext, FieldSortFieldReference<? super SR, T> fieldReference) {
        return new FieldReferenceFieldSortOptionsStep(dslContext, fieldReference);
    }

    public static <PDF extends TypedSearchPredicateFactory<SR>, SR, SC extends SearchSortIndexScope<?>> FieldSortOptionsStep<SR, ?, PDF> create(SearchSortDslContext<SR, SC, PDF> dslContext, String fieldPath) {
        return new StringFieldSortOptionsStep<SR, PDF>(dslContext, fieldPath);
    }

    @Override
    public S order(SortOrder order) {
        this.builder.order(order);
        return this.thisAsS();
    }

    @Override
    public S mode(SortMode mode) {
        this.builder.mode(mode);
        return this.thisAsS();
    }

    @Override
    public N missing() {
        return this.thisAsN();
    }

    @Override
    public S filter(Function<? super PDF, ? extends PredicateFinalStep> clauseContributor) {
        SearchPredicate predicate = clauseContributor.apply(this.dslContext.predicateFactory()).toPredicate();
        return (S)this.filter(predicate);
    }

    @Override
    public S filter(SearchPredicate searchPredicate) {
        this.builder.filter(searchPredicate);
        return this.thisAsS();
    }

    public S first() {
        this.builder.missingFirst();
        return this.thisAsS();
    }

    public S last() {
        this.builder.missingLast();
        return this.thisAsS();
    }

    public S highest() {
        this.builder.missingHighest();
        return this.thisAsS();
    }

    public S lowest() {
        this.builder.missingLowest();
        return this.thisAsS();
    }

    @Override
    protected SearchSort build() {
        return this.builder.build();
    }

    protected abstract S thisAsS();

    protected abstract N thisAsN();

    private static class FieldReferenceFieldSortOptionsStep<SR, T, PDF extends TypedSearchPredicateFactory<SR>>
    extends AbstractFieldSortOptionsGenericStep<SR, T, PDF, FieldReferenceFieldSortOptionsStep<SR, T, PDF>, FieldReferenceFieldSortOptionsStep<SR, T, PDF>>
    implements FieldSortMissingValueBehaviorGenericStep<T, FieldReferenceFieldSortOptionsStep<SR, T, PDF>> {
        private final ValueModel valueModel;

        public FieldReferenceFieldSortOptionsStep(SearchSortDslContext<SR, ?, ? extends PDF> dslContext, FieldSortFieldReference<? super SR, ?> fieldReference) {
            super(dslContext, fieldReference.absolutePath());
            this.valueModel = fieldReference.valueModel();
        }

        @Override
        public FieldReferenceFieldSortOptionsStep<SR, T, PDF> use(T value) {
            this.builder.missingAs(value, this.valueModel);
            return this;
        }

        @Override
        protected FieldReferenceFieldSortOptionsStep<SR, T, PDF> thisAsS() {
            return this;
        }

        @Override
        protected FieldReferenceFieldSortOptionsStep<SR, T, PDF> thisAsN() {
            return this;
        }
    }

    private static class StringFieldSortOptionsStep<SR, PDF extends TypedSearchPredicateFactory<SR>>
    extends AbstractFieldSortOptionsGenericStep<SR, Object, PDF, StringFieldSortOptionsStep<SR, PDF>, FieldSortMissingValueBehaviorStep<StringFieldSortOptionsStep<SR, PDF>>>
    implements FieldSortOptionsStep<SR, StringFieldSortOptionsStep<SR, PDF>, PDF>,
    FieldSortMissingValueBehaviorStep<StringFieldSortOptionsStep<SR, PDF>> {
        public StringFieldSortOptionsStep(SearchSortDslContext<SR, ?, ? extends PDF> dslContext, String fieldPath) {
            super(dslContext, fieldPath);
        }

        @Override
        public StringFieldSortOptionsStep<SR, PDF> use(Object value, ValueModel valueModel) {
            this.builder.missingAs(value, valueModel);
            return this;
        }

        @Override
        protected StringFieldSortOptionsStep<SR, PDF> thisAsS() {
            return this;
        }

        @Override
        protected StringFieldSortOptionsStep<SR, PDF> thisAsN() {
            return this;
        }
    }
}

