/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.service;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.jboss.as.server.suspend.ServerResumeContext;
import org.jboss.as.server.suspend.ServerSuspendContext;
import org.jboss.as.server.suspend.SuspendableActivity;
import org.jboss.as.server.suspend.SuspendableActivityRegistry;
import org.jboss.as.server.suspend.SuspensionStateProvider;
import org.wildfly.clustering.server.manager.Service;

public class SuspendableService
implements Service {
    private final Service service;
    private final SuspendableActivityRegistry registry;
    private final SuspendableActivity activity;

    public SuspendableService(final Service service, SuspendableActivityRegistry registry, final Executor executor) {
        this.service = service;
        this.registry = registry;
        this.activity = new SuspendableActivity(){

            public CompletionStage<Void> suspend(ServerSuspendContext context) {
                if (context.isStarting()) {
                    return SuspendableActivity.COMPLETED;
                }
                return CompletableFuture.runAsync(() -> ((Service)service).stop(), executor);
            }

            public CompletionStage<Void> resume(ServerResumeContext context) {
                return CompletableFuture.runAsync(() -> ((Service)service).start(), executor);
            }
        };
    }

    public boolean isStarted() {
        return this.service.isStarted();
    }

    public void start() {
        this.registry.registerActivity(this.activity);
        if (this.registry.getState() == SuspensionStateProvider.State.RUNNING) {
            this.service.start();
        }
    }

    public void stop() {
        if (this.registry.getState() == SuspensionStateProvider.State.RUNNING) {
            this.service.stop();
        }
        this.registry.unregisterActivity(this.activity);
    }
}

