/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.vertx;

import io.vertx.core.VertxOptions;
import io.vertx.core.dns.AddressResolverOptions;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.vertx.AbstractVertxOptionsResourceDefinition;
import org.wildfly.extension.vertx.AddressResolverResourceDefinition;
import org.wildfly.extension.vertx.NamedVertxOptions;
import org.wildfly.extension.vertx.VertxOptionsAttributes;
import org.wildfly.extension.vertx.VertxOptionsRegistry;
import org.wildfly.extension.vertx.VertxOptionsResourceDefinition;

public class NamedVertxOptionsService
implements Service {
    private final NamedVertxOptions namedVertxOptions;
    private final Consumer<NamedVertxOptions> consumer;
    private final Supplier<AddressResolverOptions> addressResolverOptionsSupplier;
    private final Supplier<ServerEnvironment> serverEnvironmentSupplier;
    private final boolean defaultFileCacheDir;

    NamedVertxOptionsService(NamedVertxOptions namedVertxOptions, Supplier<AddressResolverOptions> addressResolverOptionsSupplier, Supplier<ServerEnvironment> serverEnvironmentSupplier, boolean defaultFileCacheDir, Consumer<NamedVertxOptions> consumer) {
        this.namedVertxOptions = namedVertxOptions;
        this.addressResolverOptionsSupplier = addressResolverOptionsSupplier;
        this.serverEnvironmentSupplier = serverEnvironmentSupplier;
        this.defaultFileCacheDir = defaultFileCacheDir;
        this.consumer = consumer;
    }

    static void installVertxOptionsService(OperationContext context, ModelNode operation) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        VertxOptions vertxOptions = VertxOptionsResourceDefinition.parseOptions(operation);
        ServiceName vertxServiceName = AbstractVertxOptionsResourceDefinition.VERTX_OPTIONS_CAPABILITY.getCapabilityServiceName(new String[]{name});
        CapabilityServiceBuilder vertxServiceBuilder = context.getCapabilityServiceTarget().addService();
        Supplier addressResolverOptionsSupplier = null;
        if (operation.hasDefined("address-resolver-option")) {
            String addressResolverOptionName = VertxOptionsAttributes.ATTR_VERTX_OPTION_ADDRESS_RESOLVER.validateOperation(operation).asString();
            ServiceName addressResolverServiceName = AddressResolverResourceDefinition.VERTX_OPTIONS_ADDRESS_RESOLVER_CAPABILITY.getCapabilityServiceName(new String[]{addressResolverOptionName});
            addressResolverOptionsSupplier = vertxServiceBuilder.requires(addressResolverServiceName);
        }
        NamedVertxOptions namedVertxOptions = new NamedVertxOptions(name, vertxOptions);
        ServiceName serverEnvServiceName = context.getCapabilityServiceName(ServerEnvironment.SERVICE_DESCRIPTOR);
        Supplier environmentSupplier = vertxServiceBuilder.requires(serverEnvServiceName);
        vertxServiceBuilder.setInstance((Service)new NamedVertxOptionsService(namedVertxOptions, addressResolverOptionsSupplier, environmentSupplier, !operation.hasDefined("file-cache-dir"), vertxServiceBuilder.provides(new ServiceName[]{vertxServiceName})));
        vertxServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    public void start(StartContext startContext) throws StartException {
        if (this.addressResolverOptionsSupplier != null && this.addressResolverOptionsSupplier.get() != null) {
            this.namedVertxOptions.getVertxOptions().setAddressResolverOptions(this.addressResolverOptionsSupplier.get());
        }
        if (this.defaultFileCacheDir) {
            String defaultCacheDir = this.serverEnvironmentSupplier.get().getServerTempDir().toPath().resolve(Path.of("vertx-cache", new String[0])).normalize().toString();
            this.namedVertxOptions.getVertxOptions().getFileSystemOptions().setFileCacheDir(defaultCacheDir);
        }
        this.consumer.accept(this.namedVertxOptions);
        VertxOptionsRegistry.getInstance().addVertxOptions(this.namedVertxOptions);
    }

    public void stop(StopContext stopContext) {
        VertxOptionsRegistry.getInstance().removeVertxOptions(this.namedVertxOptions.getName());
    }
}

