/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.vertx.logging;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.vertx.logging.VertxLogger;

public class VertxLogger_$logger
extends DelegatingBasicLogger
implements VertxLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = VertxLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public VertxLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String cannotReadVertxOptionsFile$str() {
        return "WFLYVTX0001: Could not read VertxOptions from file: %s";
    }

    @Override
    public final OperationFailedException cannotReadVertxOptionsFile(String vertxOptionsFile) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.cannotReadVertxOptionsFile$str(), vertxOptionsFile));
        VertxLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String failedToReadVertxOptions$str() {
        return "WFLYVTX0002: Could not find VertxOptions from: %s";
    }

    @Override
    public final OperationFailedException failedToReadVertxOptions(String vertxOptionsFile, Exception e) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.failedToReadVertxOptions$str(), vertxOptionsFile), (Throwable)e);
        VertxLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String failedToStartVertxService$str() {
        return "WFLYVTX0003: Failed to start VertxProxyService";
    }

    @Override
    public final StartException failedToStartVertxService(Throwable e) {
        StartException result = new StartException(String.format(this.getLoggingLocale(), this.failedToStartVertxService$str(), new Object[0]), e);
        VertxLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void errorWhenClosingVertx(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.errorWhenClosingVertx$str(), new Object[0]);
    }

    protected String errorWhenClosingVertx$str() {
        return "WFLYVTX0004: Error when closing the Vert.x instance";
    }

    protected String deploymentRequiresCapability$str() {
        return "WFLYVTX0005: Deployment %s requires use of the '%s' capability but it is not currently registered";
    }

    @Override
    public final DeploymentUnitProcessingException deploymentRequiresCapability(String deploymentName, String capabilityName) {
        DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(this.getLoggingLocale(), this.deploymentRequiresCapability$str(), deploymentName, capabilityName));
        VertxLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String noOptionsFileSpecified$str() {
        return "WFLYVTX0006: Path of the vertx-options-file %s must be specified";
    }

    @Override
    public final OperationFailedException noOptionsFileSpecified(String optionName) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.noOptionsFileSpecified$str(), optionName));
        VertxLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String absoluteDirectoryNotAllowed$str() {
        return "WFLYVTX0007: Absolute directory %s is not allowed for the VertxOptions file";
    }

    @Override
    public final OperationFailedException absoluteDirectoryNotAllowed(String dir) {
        OperationFailedException result = new OperationFailedException(String.format(this.getLoggingLocale(), this.absoluteDirectoryNotAllowed$str(), dir));
        VertxLogger_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    @Override
    public final void useVertxFromSubsystem() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.useVertxFromSubsystem$str(), new Object[0]);
    }

    protected String useVertxFromSubsystem$str() {
        return "WFLYVTX0008: Use Vertx instance from vertx subsystem";
    }

    protected String noVertxDefined$str() {
        return "WFLYVTX0009: There is no vertx defined from vertx subsystem";
    }

    @Override
    public final IllegalStateException noVertxDefined() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.noVertxDefined$str(), new Object[0]));
        VertxLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

