/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.vertx.processors;

import jakarta.enterprise.inject.spi.Extension;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.weld.WeldCapability;
import org.wildfly.extension.vertx.logging.VertxLogger;
import org.wildfly.extension.vertx.processors.CDIExtension;

public class DeploymentInjectionProcessor
implements DeploymentUnitProcessor {
    public static final Phase PHASE = Phase.POST_MODULE;
    public static final int PRIORITY = 16384;

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        WeldCapability weldCapability;
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        try {
            weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw VertxLogger.VERTX_LOGGER.deploymentRequiresCapability(deploymentUnit.getName(), "org.wildfly.weld");
        }
        if (weldCapability.isPartOfWeldDeployment(deploymentUnit)) {
            weldCapability.registerExtensionInstance((Extension)new CDIExtension(), deploymentUnit);
        }
    }
}

