/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.vertx.processors;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;
import org.jboss.vfs.VirtualFile;
import org.wildfly.extension.vertx.processors.VertxDeploymentAttachment;

public class VerticleDeploymentMarkerProcessor
implements DeploymentUnitProcessor {
    public static final Phase PHASE = Phase.PARSE;
    public static final int PRIORITY = 16384;
    private static final DotName DOT_NAME_INJECTION = DotName.createSimple((String)"jakarta.inject.Inject");
    private static final DotName DOT_NAME_VERTX_ANNOTATION = DotName.createSimple((String)"io.vertx.core.Vertx");
    private static final DotName DOT_NAME_VERTX_MUTINY_ANNOTATION = DotName.createSimple((String)"io.vertx.mutiny.core.Vertx");
    private static final DotName DOT_NAME_CDI_INSTANCE = DotName.createSimple((String)"jakarta.enterprise.inject.Instance");
    private static final Set<DotName> VERTX_CLASSES = new HashSet<DotName>();

    public void deploy(DeploymentPhaseContext context) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = context.getDeploymentUnit();
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (this.annotated(index, DOT_NAME_INJECTION) || this.descriptorExists(deploymentUnit)) {
            VertxDeploymentAttachment.attachVertxDeployments(deploymentUnit);
        }
    }

    private boolean descriptorExists(DeploymentUnit deploymentUnit) {
        ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (deploymentRoot != null && deploymentRoot.getRoot() != null) {
            VirtualFile vertxDeploymentFile = deploymentRoot.getRoot().getChild("WEB-INF/vertx.json");
            if (vertxDeploymentFile == null || !vertxDeploymentFile.exists()) {
                vertxDeploymentFile = deploymentRoot.getRoot().getChild("META-INF/vertx.json");
            }
            return vertxDeploymentFile != null && vertxDeploymentFile.exists() && vertxDeploymentFile.isFile();
        }
        return false;
    }

    private boolean annotated(CompositeIndex index, DotName injectAnnotationName) {
        List resourceAnnotations = index.getAnnotations(injectAnnotationName);
        for (AnnotationInstance annotation : resourceAnnotations) {
            List arguments;
            AnnotationTarget annotationTarget = annotation.target();
            if (!(annotationTarget instanceof FieldInfo)) continue;
            Type type = annotationTarget.asField().type();
            DotName fieldType = type.name();
            if (VERTX_CLASSES.contains(fieldType)) {
                return true;
            }
            if (!DOT_NAME_CDI_INSTANCE.equals((Object)fieldType) || type.kind() != Type.Kind.PARAMETERIZED_TYPE || (arguments = type.asParameterizedType().arguments()).size() != 1 || !VERTX_CLASSES.contains(((Type)arguments.get(0)).name())) continue;
            return true;
        }
        return false;
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
        VertxDeploymentAttachment.removeVertxDeploymentsMeta(deploymentUnit);
    }

    static {
        VERTX_CLASSES.add(DOT_NAME_VERTX_ANNOTATION);
        VERTX_CLASSES.add(DOT_NAME_VERTX_MUTINY_ANNOTATION);
    }
}

