/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.tool;

import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.wildfly.security.tool.Command;
import org.wildfly.security.tool.ElytronToolMessages;
import org.wildfly.security.tool.help.DescriptionSection;
import org.wildfly.security.tool.help.HelpCommand;
import org.wildfly.security.tool.help.OptionsSection;
import org.wildfly.security.tool.help.UsageSection;
import org.wildfly.security.util.PasswordBasedEncryptionUtil;
import org.wildfly.security.util.PasswordUtil;

class MaskCommand
extends Command {
    public static final String MASK_COMMAND = "mask";
    static final String SECRET_PARAM = "secret";
    private final int defaultIterationCount = 10000;
    private final Options options;
    private CommandLineParser parser = new DefaultParser();
    private CommandLine cmdLine = null;

    MaskCommand() {
        Option salt = new Option("s", "salt", true, ElytronToolMessages.msg.cmdMaskSaltDesc());
        Option iteration = new Option("i", "iteration", true, ElytronToolMessages.msg.cmdMaskIterationCountDesc());
        Option h = new Option("h", "help", false, ElytronToolMessages.msg.cmdLineHelp());
        Option x = new Option("x", SECRET_PARAM, true, ElytronToolMessages.msg.cmdMaskSecretDesc());
        Option d = new Option("d", "debug", false, ElytronToolMessages.msg.cmdLineDebug());
        x.setArgName("to encrypt");
        this.options = new Options();
        this.options.addOption(x);
        this.options.addOption(h);
        this.options.addOption(salt);
        this.options.addOption(iteration);
        this.options.addOption(d);
    }

    @Override
    public void execute(String[] args) throws Exception {
        String secret;
        if (new SecureRandom().getProvider().getName().toLowerCase().contains("fips")) {
            System.out.println(ElytronToolMessages.msg.fipsModeNotAllowed());
            return;
        }
        this.setStatus(7);
        this.cmdLine = this.parser.parse(this.options, args, false);
        this.setEnableDebug(this.cmdLine.hasOption("debug"));
        if (this.cmdLine.hasOption("help")) {
            this.help();
            this.setStatus(0);
            return;
        }
        this.printDuplicatesWarning(this.cmdLine);
        String salt = this.cmdLine.getOptionValue("salt");
        if (salt == null) {
            salt = PasswordUtil.generateSecureRandomString((int)8);
            System.out.println(ElytronToolMessages.msg.invalidParameterGeneratedWillBeUsed("salt", salt));
        }
        String sIteration = this.cmdLine.getOptionValue("iteration");
        int iterationCount = -1;
        if (sIteration != null && !sIteration.isEmpty()) {
            try {
                iterationCount = Integer.parseInt(sIteration);
                if (iterationCount < 1) {
                    System.out.println(ElytronToolMessages.msg.invalidParameterMustBeIntBetween("iteration", 1, Integer.MAX_VALUE));
                }
            }
            catch (NumberFormatException e) {
                System.out.println(ElytronToolMessages.msg.invalidParameterMustBeIntBetween("iteration", 1, Integer.MAX_VALUE));
            }
        }
        if (iterationCount < 1) {
            System.out.println(ElytronToolMessages.msg.invalidParameterDefaultWillBeUsed("iteration", Integer.toString(10000)));
            iterationCount = 10000;
        }
        if ((secret = this.cmdLine.getOptionValue(SECRET_PARAM)) == null && (secret = this.prompt(false, ElytronToolMessages.msg.maskSecretPrompt(), true, ElytronToolMessages.msg.maskSecretPromptConfirm())) == null) {
            this.setStatus(7);
            throw ElytronToolMessages.msg.secretNotSpecified();
        }
        String masked = MaskCommand.computeMasked(secret, salt, iterationCount);
        this.setStatus(0);
        System.out.println(masked);
    }

    static String computeMasked(String secret, String salt, int iteration) throws GeneralSecurityException {
        PasswordBasedEncryptionUtil encryptUtil = new PasswordBasedEncryptionUtil.Builder().picketBoxCompatibility().salt(salt).iteration(iteration).encryptMode().build();
        return "MASK-" + encryptUtil.encryptAndEncode(secret.toCharArray()) + ";" + salt + ";" + String.valueOf(iteration);
    }

    static char[] decryptMasked(String maskedPassword) throws GeneralSecurityException {
        int maskLength = "MASK-".length();
        if (maskedPassword == null || maskedPassword.length() <= maskLength) {
            throw ElytronToolMessages.msg.wrongMaskedPasswordFormat();
        }
        String[] parsed = maskedPassword.substring(maskLength).split(";");
        if (parsed.length != 3) {
            throw ElytronToolMessages.msg.wrongMaskedPasswordFormat();
        }
        String encoded = parsed[0];
        String salt = parsed[1];
        int iteration = Integer.parseInt(parsed[2]);
        PasswordBasedEncryptionUtil encryptUtil = new PasswordBasedEncryptionUtil.Builder().picketBoxCompatibility().salt(salt).iteration(iteration).decryptMode().build();
        return encryptUtil.decodeAndDecrypt(encoded);
    }

    @Override
    public void help() {
        OptionsSection optionsSection = new OptionsSection(ElytronToolMessages.msg.cmdLineActionsHelpHeader(), this.options);
        UsageSection usageSection = new UsageSection(MASK_COMMAND, null);
        DescriptionSection descriptionSection = new DescriptionSection(ElytronToolMessages.msg.cmdMaskHelpHeader());
        HelpCommand helpCommand = HelpCommand.HelpCommandBuilder.builder().description(descriptionSection).usage(usageSection).options(optionsSection).build();
        helpCommand.printHelp();
    }
}

