/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.cfg;

import org.hibernate.annotations.UuidGenerator;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.ConfigurationLog;
import org.hibernate.search.util.common.annotation.Incubating;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Incubating
public enum UuidGenerationStrategy {
    AUTO("auto"){

        @Override
        public String strategy() {
            return RANDOM.strategy();
        }
    }
    ,
    RANDOM("random"){

        @Override
        public String strategy() {
            return UuidGenerator.Style.RANDOM.name();
        }
    }
    ,
    TIME("time"){

        @Override
        public String strategy() {
            return UuidGenerator.Style.TIME.name();
        }
    };

    private final String externalRepresentation;

    private UuidGenerationStrategy(String externalRepresentation) {
        this.externalRepresentation = externalRepresentation;
    }

    public String externalRepresentation() {
        return this.externalRepresentation;
    }

    public abstract String strategy();

    public static UuidGenerationStrategy of(String value) {
        return (UuidGenerationStrategy)((Object)ParseUtils.parseDiscreteValues((Object[])UuidGenerationStrategy.values(), UuidGenerationStrategy::externalRepresentation, ConfigurationLog.INSTANCE::invalidUuidGenerationStrategyName, (String)value));
    }
}

