/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.cluster.impl;

import java.util.Optional;
import java.util.function.Consumer;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.spi.AdditionalMappingContributions;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;
import org.hibernate.search.mapper.orm.bootstrap.spi.HibernateSearchOrmMappingProducer;
import org.hibernate.search.mapper.orm.outboxpolling.cfg.HibernateOrmMapperOutboxPollingSettings;
import org.hibernate.search.mapper.orm.outboxpolling.cfg.UuidGenerationStrategy;
import org.hibernate.search.mapper.orm.outboxpolling.cfg.impl.UuidDataTypeUtils;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.outboxpolling.impl.HibernateOrmUtils;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.ConfigurationLog;
import org.hibernate.search.mapper.orm.outboxpolling.mapping.impl.AdditionalMappingBuilder;
import org.hibernate.search.mapper.orm.outboxpolling.mapping.impl.JaxbMappingHelper;

public class OutboxPollingAgentAdditionalMappingProducer
implements HibernateSearchOrmMappingProducer {
    public static final String CLASS_NAME;
    public static final String ENTITY_NAME;
    public static final String ENTITY_DEFINITION = "<entity-mappings xmlns=\"http://www.hibernate.org/xsd/orm/mapping\">\n    <entity name=\"org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.Agent\" class=\"org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.Agent\" access=\"FIELD\">\n        <table name=\"HSEARCH_AGENT\" catalog=\"\" schema=\"\"/>\n        <attributes>\n            <id name=\"id\">\n                <uuid-generator style=\"random\"/>\n            </id>\n            <basic name=\"type\">\n                <column name=\"type\" nullable=\"false\"/>\n                <enumerated>STRING</enumerated>\n            </basic>\n            <basic name=\"name\">\n                <column name=\"name\" nullable=\"false\"/>\n            </basic>\n            <basic name=\"expiration\">\n                <column name=\"expiration\" nullable=\"false\"/>\n            </basic>\n            <basic name=\"state\">\n                <column name=\"state\" nullable=\"false\"/>\n                <enumerated>STRING</enumerated>\n            </basic>\n            <basic name=\"totalShardCount\">\n                <column name=\"totalShardCount\" nullable=\"true\"/>\n            </basic>\n            <basic name=\"assignedShardIndex\">\n                <column name=\"assignedShardIndex\" nullable=\"true\"/>\n            </basic>\n            <basic name=\"payload\">\n                <column name=\"payload\" nullable=\"true\" length=\"2147483647\"/>\n            </basic>\n        </attributes>\n    </entity>\n</entity-mappings>";
    private static final OptionalConfigurationProperty<String> AGENT_ENTITY_MAPPING;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_AGENT_SCHEMA;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_AGENT_CATALOG;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_AGENT_TABLE;
    private static final OptionalConfigurationProperty<UuidGenerationStrategy> ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY;
    private static final OptionalConfigurationProperty<String> ENTITY_MAPPING_AGENT_UUID_TYPE;

    public Consumer<AdditionalMappingContributions> produceMappingContributor(ConfigurationPropertySource propertySource, MetadataBuildingContext buildingContext) {
        Optional mapping = (Optional)AGENT_ENTITY_MAPPING.get(propertySource);
        Optional schema = (Optional)ENTITY_MAPPING_AGENT_SCHEMA.get(propertySource);
        Optional catalog = (Optional)ENTITY_MAPPING_AGENT_CATALOG.get(propertySource);
        Optional table = (Optional)ENTITY_MAPPING_AGENT_TABLE.get(propertySource);
        Optional uuidStrategy = (Optional)ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY.get(propertySource);
        Optional uuidType = ENTITY_MAPPING_AGENT_UUID_TYPE.getAndMap(propertySource, value -> UuidDataTypeUtils.uuidType(value, propertySource, ENTITY_MAPPING_AGENT_UUID_TYPE));
        if (mapping.isPresent() && (schema.isPresent() || catalog.isPresent() || table.isPresent() || uuidStrategy.isPresent() || uuidType.isPresent())) {
            throw ConfigurationLog.INSTANCE.agentConfigurationPropertyConflict(AGENT_ENTITY_MAPPING.resolveOrRaw(propertySource), new String[]{ENTITY_MAPPING_AGENT_SCHEMA.resolveOrRaw(propertySource), ENTITY_MAPPING_AGENT_CATALOG.resolveOrRaw(propertySource), ENTITY_MAPPING_AGENT_TABLE.resolveOrRaw(propertySource), ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY.resolveOrRaw(propertySource), ENTITY_MAPPING_AGENT_UUID_TYPE.resolveOrRaw(propertySource)});
        }
        if (mapping.isPresent()) {
            JaxbEntityMappingsImpl mappings = JaxbMappingHelper.unmarshall((String)mapping.get());
            ConfigurationLog.INSTANCE.agentGeneratedEntityMapping(mappings);
            return contributions -> {
                contributions.contributeEntity(Agent.class);
                contributions.contributeBinding(mappings);
            };
        }
        Integer resolvedUuidType = uuidType.orElse(null);
        String resolvedUuidStrategy = uuidStrategy.orElse(HibernateOrmMapperOutboxPollingSettings.Defaults.COORDINATION_ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY).strategy();
        ClassDetails mappings = OutboxPollingAgentAdditionalMappingProducer.createMappings(buildingContext, schema.orElse(""), catalog.orElse(""), table.orElse("HSEARCH_AGENT"), resolvedUuidType, resolvedUuidStrategy, HibernateOrmUtils.isDiscriminatorMultiTenancyEnabled(buildingContext));
        ConfigurationLog.INSTANCE.agentGeneratedEntityMappingClassDetails(mappings);
        return contributions -> {
            contributions.contributeEntity(Agent.class);
            contributions.contributeManagedClass(mappings);
        };
    }

    private static ClassDetails createMappings(MetadataBuildingContext buildingContext, String schema, String catalog, String table, Integer resolvedUuidType, String resolvedUuidStrategy, boolean tenantIdRequired) {
        AdditionalMappingBuilder builder = new AdditionalMappingBuilder(buildingContext, Agent.class, ENTITY_NAME).id(resolvedUuidType, resolvedUuidStrategy).table(schema, catalog, table).enumAttribute("type", null, false).attribute("name", null, false).attribute("expiration", null, false).enumAttribute("state", null, false).attribute("totalShardCount", null, true).attribute("assignedShardIndex", null, true).attribute("payload", Integer.MAX_VALUE, true);
        if (tenantIdRequired) {
            builder.tenantId("tenantId");
        }
        return builder.build();
    }

    static {
        ENTITY_NAME = CLASS_NAME = Agent.class.getName();
        AGENT_ENTITY_MAPPING = ConfigurationProperty.forKey((String)"agent.entity.mapping").asString().build();
        ENTITY_MAPPING_AGENT_SCHEMA = ConfigurationProperty.forKey((String)"entity.mapping.agent.schema").asString().build();
        ENTITY_MAPPING_AGENT_CATALOG = ConfigurationProperty.forKey((String)"entity.mapping.agent.catalog").asString().build();
        ENTITY_MAPPING_AGENT_TABLE = ConfigurationProperty.forKey((String)"entity.mapping.agent.table").asString().build();
        ENTITY_MAPPING_AGENT_UUID_GEN_STRATEGY = ConfigurationProperty.forKey((String)"entity.mapping.agent.uuid_gen_strategy").as(UuidGenerationStrategy.class, UuidGenerationStrategy::of).build();
        ENTITY_MAPPING_AGENT_UUID_TYPE = ConfigurationProperty.forKey((String)"entity.mapping.outboxevent.uuid_type").asString().build();
    }
}

