/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.event.impl;

import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.PessimisticLockException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.Timeouts;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.lock.spi.LockTimeoutType;
import org.hibernate.query.Query;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxPollingOutboxEventAdditionalMappingProducer;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.OutboxPollingEventsLog;
import org.hibernate.search.util.common.spi.ToStringTreeAppendable;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

final class OutboxEventLoader
implements ToStringTreeAppendable {
    private static final String LOAD_QUERY_STRING = "select e from " + OutboxPollingOutboxEventAdditionalMappingProducer.ENTITY_NAME + " e where e.id in (:ids)";
    private final LockMode lockMode;

    OutboxEventLoader(Dialect dialect) {
        this.lockMode = dialect.getLockingSupport().getMetadata().getLockTimeoutType(Timeouts.SKIP_LOCKED) == LockTimeoutType.QUERY ? LockMode.UPGRADE_SKIPLOCKED : LockMode.PESSIMISTIC_WRITE;
    }

    public String toString() {
        return this.toStringTree();
    }

    public void appendTo(ToStringTreeAppender appender) {
        appender.startObject("lockOptions").attribute("lockMode", (Object)this.lockMode).endObject();
    }

    List<OutboxEvent> loadLocking(Session session, Set<UUID> ids, String processorName) {
        try {
            Query query = session.createQuery(LOAD_QUERY_STRING, OutboxEvent.class);
            query.setParameter("ids", ids);
            query.setHibernateLockMode(this.lockMode);
            return query.getResultList();
        }
        catch (OptimisticLockException | PessimisticLockException lockException) {
            OutboxPollingEventsLog.INSTANCE.outboxEventProcessorUnableToLock(processorName, (PersistenceException)lockException);
            return Collections.emptyList();
        }
    }
}

