/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentReference;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.ClassDetailsMappingsFormatter;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.ConfigurationLog;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.JaxbEntityMappingsFormatter;
import org.hibernate.search.util.common.SearchException;
import org.jboss.logging.Logger;

public class ConfigurationLog_$logger
implements ConfigurationLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConfigurationLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public ConfigurationLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void outboxEventGeneratedEntityMapping(JaxbEntityMappingsImpl mappings) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.outboxEventGeneratedEntityMapping$str(), (Object)new JaxbEntityMappingsFormatter(mappings));
    }

    protected String outboxEventGeneratedEntityMapping$str() {
        return "HSEARCH850001: Generated entity mapping for outbox events used in the outbox-polling coordination strategy: %1$s";
    }

    protected String invalidTotalShardCount$str() {
        return "HSEARCH850007: The total shard count must be strictly positive.";
    }

    @Override
    public final SearchException invalidTotalShardCount() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidTotalShardCount$str(), new Object[0]));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    protected String invalidShardIndex$str() {
        return "HSEARCH850008: Shard indices must be between 0 (inclusive) and %1d (exclusive, set by '%2$s').";
    }

    @Override
    public final SearchException invalidShardIndex(int totalShardCount, String totalShardCountPropertyKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidShardIndex$str(), totalShardCount, totalShardCountPropertyKey));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingPropertyForStaticSharding$str() {
        return "HSEARCH850009: This property must be set when '%s' is set.";
    }

    @Override
    public final SearchException missingPropertyForStaticSharding(String otherPropertyKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingPropertyForStaticSharding$str(), otherPropertyKey));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void eventProcessorDisabled(String tenantId) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.eventProcessorDisabled$str(), (Object)tenantId);
    }

    protected String eventProcessorDisabled$str() {
        return "HSEARCH850010: The outbox event processor is disabled for tenant '%s'.  Events will accumulate in the outbox table and indexes will not be updated, unless another application node connects to the same database with their event processor enabled.";
    }

    @Override
    public final void agentGeneratedEntityMapping(JaxbEntityMappingsImpl xmlMappingDefinition) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.agentGeneratedEntityMapping$str(), (Object)new JaxbEntityMappingsFormatter(xmlMappingDefinition));
    }

    protected String agentGeneratedEntityMapping$str() {
        return "HSEARCH850014: Generated entity mapping for agents used in the outbox-polling coordination strategy: %1$s";
    }

    protected String invalidPollingIntervalAndPulseInterval$str() {
        return "HSEARCH850015: The pulse interval must be greater than or equal to the polling interval i.e. in this case at least %s";
    }

    @Override
    public final SearchException invalidPollingIntervalAndPulseInterval(long pollingInterval) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidPollingIntervalAndPulseInterval$str(), pollingInterval));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPulseIntervalAndPulseExpiration$str() {
        return "HSEARCH850016: The pulse expiration must be greater than or equal to 3 times the pulse interval i.e. in this case at least %s";
    }

    @Override
    public final SearchException invalidPulseIntervalAndPulseExpiration(long pulseInterfaceTimes3) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidPulseIntervalAndPulseExpiration$str(), pulseInterfaceTimes3));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingOutboxEventBackgroundProcessorAgentTotalShardCountForStaticSharding$str() {
        return "HSEARCH850019: Agent '%1$s' is statically assigned to %2$s, but this conflicts with agent '%3$s' which expects %4$s shards. This can be a temporary situation caused by some application instances being forcibly stopped and replacements being spun up, in which case the problem will resolve itself after a few seconds once the registration of the old instances expires. However, if the situation persists, this indicates misconfiguration, with multiple application instances participating in event processing and expecting a different amount of shards; consider adjusting the configuration or switching to dynamic sharding.";
    }

    @Override
    public final SearchException conflictingOutboxEventBackgroundProcessorAgentTotalShardCountForStaticSharding(AgentReference reference, ShardAssignmentDescriptor staticShardAssignment, AgentReference conflictingAgentReference, int conflictingAgentTotalShardCount) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingOutboxEventBackgroundProcessorAgentTotalShardCountForStaticSharding$str(), reference, staticShardAssignment, conflictingAgentReference, conflictingAgentTotalShardCount));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String conflictingOutboxEventBackgroundProcessorAgentShardsForStaticSharding$str() {
        return "HSEARCH850020: Agent '%1$s' is statically assigned to %2$s, but this conflicts with agent '%3$s' which is also assigned to that shard. This can be a temporary situation caused by some application instances being forcibly stopped and replacements being spun up, in which case the problem will resolve itself after a few seconds once the registration of the old instances expires. However, if the situation persists, this indicates misconfiguration, with multiple application instances participating in event processing and being assigned to the same shard; consider adjusting the configuration or switching to dynamic sharding.";
    }

    @Override
    public final SearchException conflictingOutboxEventBackgroundProcessorAgentShardsForStaticSharding(AgentReference reference, ShardAssignmentDescriptor staticShardAssignment, AgentReference conflictingAgentReference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.conflictingOutboxEventBackgroundProcessorAgentShardsForStaticSharding$str(), reference, staticShardAssignment, conflictingAgentReference));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String outboxPollingExtensionOnUnknownType$str() {
        return "HSEARCH850023: Invalid target for Outbox Polling extension: '%1$s'. This extension can only be applied when Hibernate Search is configured to use the 'outbox-polling' coordination strategy.";
    }

    @Override
    public final SearchException outboxPollingExtensionOnUnknownType(Object context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.outboxPollingExtensionOnUnknownType$str(), context));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noTenantIdSpecified$str() {
        return "HSEARCH850024: Multi-tenancy is enabled but no tenant id is specified. Available tenants are: '%1$s'.";
    }

    @Override
    public final SearchException noTenantIdSpecified(Set<String> tenantIds) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noTenantIdSpecified$str(), tenantIds));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String multiTenancyNotEnabled$str() {
        return "HSEARCH850025: Multi-tenancy is not enabled but a tenant id is specified. Trying to use the tenant id: '%1$s'.";
    }

    @Override
    public final SearchException multiTenancyNotEnabled(String tenantId) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multiTenancyNotEnabled$str(), tenantId));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String agentConfigurationPropertyConflict$str() {
        return "HSEARCH850026: Outbox polling agent configuration property conflict. Either mapping property %1$s or subset of name adjustment properties %2$s should be provided at the same time.";
    }

    @Override
    public final SearchException agentConfigurationPropertyConflict(String mappingPropertyName, String[] nameAdjustmentProperties) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.agentConfigurationPropertyConflict$str(), mappingPropertyName, Arrays.toString(nameAdjustmentProperties)));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String outboxEventConfigurationPropertyConflict$str() {
        return "HSEARCH850027: Outbox event configuration property conflict. Either mapping property %1$s or subset of name adjustment properties %2$s should be provided at the same time.";
    }

    @Override
    public final SearchException outboxEventConfigurationPropertyConflict(String mappingPropertyName, String[] nameAdjustmentProperties) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.outboxEventConfigurationPropertyConflict$str(), mappingPropertyName, Arrays.toString(nameAdjustmentProperties)));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidUuidGenerationStrategyName$str() {
        return "HSEARCH850030: Invalid name for the UUID generation strategy: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidUuidGenerationStrategyName(String name, List<String> values) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidUuidGenerationStrategyName$str(), name, values));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidOutboxEventProcessingOrderName$str() {
        return "HSEARCH850031: Invalid name for the outbox event processing order: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidOutboxEventProcessingOrderName(String name, List<String> values) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidOutboxEventProcessingOrderName$str(), name, values));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidPayloadTypeName$str() {
        return "HSEARCH850032: Invalid name for the payload type: '%1$s'. Valid names are: %2$s.";
    }

    @Override
    public final SearchException invalidPayloadTypeName(String name, List<String> values) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidPayloadTypeName$str(), name, values));
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToProcessEntityMappings$str() {
        return "HSEARCH850035: Unable to process provided entity mappings: %1$s";
    }

    @Override
    public final SearchException unableToProcessEntityMappings(String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToProcessEntityMappings$str(), causeMessage), (Throwable)cause);
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToParseJdbcTypeCode$str() {
        return "HSEARCH850036: Unable to parse '%1$s' as a JDBC type code or type code name. %2$s";
    }

    @Override
    public final SearchException unableToParseJdbcTypeCode(String value, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToParseJdbcTypeCode$str(), value, causeMessage), (Throwable)cause);
        ConfigurationLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void outboxEventGeneratedEntityMappingClassDetails(ClassDetails mappings) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.outboxEventGeneratedEntityMappingClassDetails$str(), (Object)new ClassDetailsMappingsFormatter(mappings));
    }

    protected String outboxEventGeneratedEntityMappingClassDetails$str() {
        return "HSEARCH850068: Generated entity mapping for outbox events used in the outbox-polling coordination strategy: %1$s";
    }

    @Override
    public final void agentGeneratedEntityMappingClassDetails(ClassDetails mappings) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.agentGeneratedEntityMappingClassDetails$str(), (Object)new ClassDetailsMappingsFormatter(mappings));
    }

    protected String agentGeneratedEntityMappingClassDetails$str() {
        return "HSEARCH850069: Generated entity mapping for agents used in the outbox-polling coordination strategy: %1$s";
    }
}

