/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.logging.impl;

import jakarta.persistence.PersistenceException;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentReference;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentState;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.ClusterDescriptor;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEvent;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.logging.impl.ToStringTreeMultilineFormatter;
import org.hibernate.search.util.common.spi.ToStringTreeAppendable;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@CategorizedLogger(category="org.hibernate.search.mapper.orm.outboxpolling", description="The main category for the outbox polling-specific logs.\nIt may also include logs that do not fit any other, more specific, outbox polling category.\n")
@MessageLogger(projectCode="HSEARCH")
public interface OutboxPollingEventsLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.mapper.orm.outboxpolling";
    public static final OutboxPollingEventsLog INSTANCE = (OutboxPollingEventsLog)LoggerFactory.make(OutboxPollingEventsLog.class, (String)"org.hibernate.search.mapper.orm.outboxpolling", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=850003, value="Max '%1$s' retries exhausted to process the event. Event will be aborted.")
    public SearchException maxRetryExhausted(int var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=850004, value="Background indexing failed for event #%1$s on entity of type '%2$s' with ID '%3$s'. Attempts so far: %4$d. The event will be reprocessed after the moment: %5$s.")
    public void backgroundIndexingRetry(UUID var1, String var2, String var3, int var4, Instant var5);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850005, value="Starting outbox event processor '%1$s': %2$s")
    public void startingOutboxEventProcessor(String var1, @FormatWith(value=ToStringTreeMultilineFormatter.class) ToStringTreeAppendable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850006, value="Stopping outbox event processor '%1$s'")
    public void stoppingOutboxEventProcessor(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850011, value="'%1$s' failed to obtain a lock on events to update/delete; will try again later.")
    public void outboxEventProcessorUnableToLock(String var1, @Cause PersistenceException var2);

    @Message(id=850012, value="Unable to serialize OutboxEvent payload with Avro: %1$s")
    public SearchException unableToSerializeOutboxEventPayloadWithAvro(String var1, @Cause Throwable var2);

    @Message(id=850013, value="Unable to deserialize OutboxEvent payload with Avro: %1$s")
    public SearchException unableToDeserializeOutboxEventPayloadWithAvro(String var1, @Cause Throwable var2);

    @Message(value="Pulse operation for agent '%1$s'")
    public String outboxEventProcessorPulse(AgentReference var1);

    @Message(id=850017, value="Agent '%1$s': failed to infer a target cluster from the list of registered agents. The agent will try again in the next pulse. Cause: %2$s Registered agents: %3$s.")
    public SearchException outboxEventProcessorPulseFailed(AgentReference var1, String var2, List<Agent> var3, @Cause RuntimeException var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=850018, value="Agent '%1$s': the registration of some agents in the outbox-polling strategy are considered expired and will be forcibly removed: %2$s. These agents did not update their registration in the database in time. This can be caused by invalid configuration (expiration lower than how long it takes to process a batch of events) or by an application node being forcibly stopped (disconnection from the network, application crash).")
    public void removingTimedOutAgents(AgentReference var1, List<Agent> var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850021, value="Starting outbox mass indexer agent '%1$s': %2$s")
    public void startingOutboxMassIndexerAgent(String var1, @FormatWith(value=ToStringTreeMultilineFormatter.class) ToStringTreeAppendable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850022, value="Stopping outbox mass indexer agent '%1$s'")
    public void stoppingOutboxMassIndexerAgent(String var1);

    @Message(id=850028, value="Agent '%1$s': could not find the agent after starting a new transaction. The agent was present just a moment ago. Either this problem is a rare occurrence, or the pulse expiration delay is too short.")
    public SearchException agentRegistrationIneffective(AgentReference var1);

    @Message(id=850029, value="Nonblocking operation submitter is not supported.")
    public SearchException nonblockingOperationSubmitterNotSupported();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=850034, value="'%1$s' failed to retrieve events to process due to a locking failure; will try again later.")
    public void eventProcessorFindEventsUnableToLock(String var1, @Cause PersistenceException var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=850038, value="Agent '%s': registering.")
    public void agentRegistering(AgentReference var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=850039, value="Agent '%s': leaving cluster.")
    public void agentLeaving(AgentReference var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=850040, value="Agent '%s': suspending.")
    public void agentSuspending(AgentReference var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=850041, value="Agent '%s': waiting for cluster changes. Shard assignment: %s. Cluster: %s")
    public void agentWaiting(AgentReference var1, ShardAssignmentDescriptor var2, ClusterDescriptor var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=850042, value="Agent '%s': running. Shard assignment: %s. Cluster: %s")
    public void agentRunning(AgentReference var1, ShardAssignmentDescriptor var2, ClusterDescriptor var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850043, value="Agent '%s': starting pulse at %s with self = %s, all agents = %s")
    public void agentPulseStarting(AgentReference var1, Instant var2, Agent var3, List<Agent> var4);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850044, value="Agent '%s': ending pulse at %s with self = %s")
    public void agentPulseEnded(AgentReference var1, Instant var2, Agent var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=850045, value="Agent '%s': reassessing the new situation in the next pulse")
    public void agentReassessing(AgentReference var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850046, value="Processing %d outbox events for '%s': '%s'")
    public void processingOutboxEvents(int var1, String var2, List<OutboxEvent> var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850047, value="Agent '%s': waiting for event processor '%s', which has not reached state '%s' yet")
    public void agentWaitingForEvents(AgentReference var1, AgentReference var2, AgentState var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850048, value="Agent '%s': all event processors reached the expected state %s")
    public void agentProcessorsExpired(AgentReference var1, AgentState var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850049, value="Agent '%s': instructions are to hold off mass indexing and to retry a pulse in %s, around %s")
    public void agentHoldMassIndexing(AgentReference var1, Duration var2, Instant var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850050, value="Agent '%s': instructions are to proceed with mass indexing and to retry a pulse in %s, around %s")
    public void agentProceedMassIndexing(AgentReference var1, Duration var2, Instant var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=850051, value="Agent '%s': the persisted shard assignment (%s) does not match the target. Target assignment: %s. Cluster: %s.")
    public void agentAssignmentDoesNotMatchTarget(AgentReference var1, ShardAssignmentDescriptor var2, ShardAssignmentDescriptor var3, ClusterDescriptor var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=850052, value="Agent '%s': assigning to %s")
    public void agentAssignment(AgentReference var1, ShardAssignmentDescriptor var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850053, value="Agent '%s': waiting for agent '%s', which has not reached state '%s' yet")
    public void agentWaitingAgentReachState(AgentReference var1, AgentReference var2, AgentState var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850054, value="Agent '%s': agents excluded from the cluster reached the expected state %s")
    public void agentExcluded(AgentReference var1, AgentState var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850055, value="Agent '%s': instructions are to not process events and to retry a pulse in %s, around %s")
    public void instructCommitAndRetryPulseAfterDelay(AgentReference var1, Duration var2, Instant var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850056, value="Agent '%s': instructions are to process events and to retry a pulse in %s, around %s")
    public void instructProceedWithEventProcessing(AgentReference var1, Duration var2, Instant var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850057, value="Agent '%s': waiting for agent '%s', whose state %s is not in the expected %s yet")
    public void clusterMembersAreInClusterWaitingForState(AgentReference var1, AgentReference var2, AgentState var3, Set<AgentState> var4);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850058, value="Agent '%s': waiting for agent '%s', whose total shard count %s is not the expected %s yet")
    public void clusterMembersAreInClusterShardCountExpectation(AgentReference var1, AgentReference var2, Integer var3, int var4);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850059, value="Agent '%s': waiting for agent '%s', whose assigned shard index %s is not the expected %s yet")
    public void clusterMembersAreInClusterSharIndexExpectation(AgentReference var1, AgentReference var2, Integer var3, int var4);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850060, value="Agent '%s': all cluster members reached the expected states %s and shard assignment %s")
    public void clusterMembersAreInClusterReachedExpectedStates(AgentReference var1, Set<AgentState> var2, ClusterDescriptor var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=850061, value="Agent '%s': some cluster members are missing; this agent will wait until they are present. Target cluster: %s.")
    public void agentClusterMembersMissingInfo(AgentReference var1, ClusterDescriptor var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850062, value="Agent '%s': some cluster members are missing; this agent will wait until they are present. Target cluster: %s.")
    public void agentClusterMembersMissingTrace(AgentReference var1, ClusterDescriptor var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=850063, value="Agent '%s': this agent is superfluous and will not perform event processing, because other agents are enough to handle all the shards. Target cluster: %s.")
    public void agentSuperfluousInfo(AgentReference var1, ClusterDescriptor var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850064, value="Agent '%s': this agent is superfluous and will not perform event processing, because other agents are enough to handle all the shards. Target cluster: %s.")
    public void agentSuperfluousTrace(AgentReference var1, ClusterDescriptor var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=850065, value="Agent '%s': another agent '%s' is currently mass indexing")
    public void agentOtherAgentIsIndexingInfo(AgentReference var1, Agent var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850066, value="Agent '%s': another agent '%s' is currently mass indexing")
    public void agentOtherAgentIsIndexingTrace(AgentReference var1, Agent var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=850067, value="Persisted %d outbox events: '%s'")
    public void eventPlanNumberOfPersistedEvents(int var1, List<OutboxEvent> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=850070, value="Agent '%s': after %d retries, failed to acquire a lock on the following outbox events: %s. Events will be re-processed at a later time.")
    public void eventLockingRetryLimitReached(AgentReference var1, int var2, Set<UUID> var3);
}

