/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.outboxpolling.logging.impl;

import jakarta.persistence.PersistenceException;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.Agent;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentReference;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.AgentState;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.ClusterDescriptor;
import org.hibernate.search.mapper.orm.outboxpolling.cluster.impl.ShardAssignmentDescriptor;
import org.hibernate.search.mapper.orm.outboxpolling.event.impl.OutboxEvent;
import org.hibernate.search.mapper.orm.outboxpolling.logging.impl.OutboxPollingEventsLog;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ToStringTreeMultilineFormatter;
import org.hibernate.search.util.common.spi.ToStringTreeAppendable;
import org.jboss.logging.Logger;

public class OutboxPollingEventsLog_$logger
implements OutboxPollingEventsLog,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = OutboxPollingEventsLog_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public OutboxPollingEventsLog_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String maxRetryExhausted$str() {
        return "HSEARCH850003: Max '%1$s' retries exhausted to process the event. Event will be aborted.";
    }

    @Override
    public final SearchException maxRetryExhausted(int retries) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.maxRetryExhausted$str(), retries));
        OutboxPollingEventsLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        if (st.length > 0) {
            e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        }
    }

    @Override
    public final void backgroundIndexingRetry(UUID eventId, String entityName, String entityId, int attempts, Instant processAfter) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.backgroundIndexingRetry$str(), new Object[]{eventId, entityName, entityId, attempts, processAfter});
    }

    protected String backgroundIndexingRetry$str() {
        return "HSEARCH850004: Background indexing failed for event #%1$s on entity of type '%2$s' with ID '%3$s'. Attempts so far: %4$d. The event will be reprocessed after the moment: %5$s.";
    }

    @Override
    public final void startingOutboxEventProcessor(String name, ToStringTreeAppendable processor) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingOutboxEventProcessor$str(), (Object)name, (Object)new ToStringTreeMultilineFormatter((Object)processor));
    }

    protected String startingOutboxEventProcessor$str() {
        return "HSEARCH850005: Starting outbox event processor '%1$s': %2$s";
    }

    @Override
    public final void stoppingOutboxEventProcessor(String name) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stoppingOutboxEventProcessor$str(), (Object)name);
    }

    protected String stoppingOutboxEventProcessor$str() {
        return "HSEARCH850006: Stopping outbox event processor '%1$s'";
    }

    @Override
    public final void outboxEventProcessorUnableToLock(String name, PersistenceException lockException) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)lockException, this.outboxEventProcessorUnableToLock$str(), (Object)name);
    }

    protected String outboxEventProcessorUnableToLock$str() {
        return "HSEARCH850011: '%1$s' failed to obtain a lock on events to update/delete; will try again later.";
    }

    protected String unableToSerializeOutboxEventPayloadWithAvro$str() {
        return "HSEARCH850012: Unable to serialize OutboxEvent payload with Avro: %1$s";
    }

    @Override
    public final SearchException unableToSerializeOutboxEventPayloadWithAvro(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToSerializeOutboxEventPayloadWithAvro$str(), causeMessage), cause);
        OutboxPollingEventsLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToDeserializeOutboxEventPayloadWithAvro$str() {
        return "HSEARCH850013: Unable to deserialize OutboxEvent payload with Avro: %1$s";
    }

    @Override
    public final SearchException unableToDeserializeOutboxEventPayloadWithAvro(String causeMessage, Throwable cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToDeserializeOutboxEventPayloadWithAvro$str(), causeMessage), cause);
        OutboxPollingEventsLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String outboxEventProcessorPulse$str() {
        return "Pulse operation for agent '%1$s'";
    }

    @Override
    public final String outboxEventProcessorPulse(AgentReference agentReference) {
        return String.format(this.getLoggingLocale(), this.outboxEventProcessorPulse$str(), agentReference);
    }

    protected String outboxEventProcessorPulseFailed$str() {
        return "HSEARCH850017: Agent '%1$s': failed to infer a target cluster from the list of registered agents. The agent will try again in the next pulse. Cause: %2$s Registered agents: %3$s.";
    }

    @Override
    public final SearchException outboxEventProcessorPulseFailed(AgentReference agentReference, String causeMessage, List<Agent> allAgentsInIdOrder, RuntimeException cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.outboxEventProcessorPulseFailed$str(), agentReference, causeMessage, allAgentsInIdOrder), (Throwable)cause);
        OutboxPollingEventsLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void removingTimedOutAgents(AgentReference agentReference, List<Agent> timedOutAgents) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.removingTimedOutAgents$str(), (Object)agentReference, timedOutAgents);
    }

    protected String removingTimedOutAgents$str() {
        return "HSEARCH850018: Agent '%1$s': the registration of some agents in the outbox-polling strategy are considered expired and will be forcibly removed: %2$s. These agents did not update their registration in the database in time. This can be caused by invalid configuration (expiration lower than how long it takes to process a batch of events) or by an application node being forcibly stopped (disconnection from the network, application crash).";
    }

    @Override
    public final void startingOutboxMassIndexerAgent(String name, ToStringTreeAppendable processor) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.startingOutboxMassIndexerAgent$str(), (Object)name, (Object)new ToStringTreeMultilineFormatter((Object)processor));
    }

    protected String startingOutboxMassIndexerAgent$str() {
        return "HSEARCH850021: Starting outbox mass indexer agent '%1$s': %2$s";
    }

    @Override
    public final void stoppingOutboxMassIndexerAgent(String name) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.stoppingOutboxMassIndexerAgent$str(), (Object)name);
    }

    protected String stoppingOutboxMassIndexerAgent$str() {
        return "HSEARCH850022: Stopping outbox mass indexer agent '%1$s'";
    }

    protected String agentRegistrationIneffective$str() {
        return "HSEARCH850028: Agent '%1$s': could not find the agent after starting a new transaction. The agent was present just a moment ago. Either this problem is a rare occurrence, or the pulse expiration delay is too short.";
    }

    @Override
    public final SearchException agentRegistrationIneffective(AgentReference agentReference) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.agentRegistrationIneffective$str(), agentReference));
        OutboxPollingEventsLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String nonblockingOperationSubmitterNotSupported$str() {
        return "HSEARCH850029: Nonblocking operation submitter is not supported.";
    }

    @Override
    public final SearchException nonblockingOperationSubmitterNotSupported() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.nonblockingOperationSubmitterNotSupported$str(), new Object[0]));
        OutboxPollingEventsLog_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void eventProcessorFindEventsUnableToLock(String name, PersistenceException lockException) {
        this.log.logf(FQCN, Logger.Level.DEBUG, (Throwable)lockException, this.eventProcessorFindEventsUnableToLock$str(), (Object)name);
    }

    protected String eventProcessorFindEventsUnableToLock$str() {
        return "HSEARCH850034: '%1$s' failed to retrieve events to process due to a locking failure; will try again later.";
    }

    @Override
    public final void agentRegistering(AgentReference agentReference) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.agentRegistering$str(), (Object)agentReference);
    }

    protected String agentRegistering$str() {
        return "HSEARCH850038: Agent '%s': registering.";
    }

    @Override
    public final void agentLeaving(AgentReference agentReference) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.agentLeaving$str(), (Object)agentReference);
    }

    protected String agentLeaving$str() {
        return "HSEARCH850039: Agent '%s': leaving cluster.";
    }

    @Override
    public final void agentSuspending(AgentReference agentReference) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.agentSuspending$str(), (Object)agentReference);
    }

    protected String agentSuspending$str() {
        return "HSEARCH850040: Agent '%s': suspending.";
    }

    @Override
    public final void agentWaiting(AgentReference agentReference, ShardAssignmentDescriptor shardAssignment, ClusterDescriptor clusterDescriptor) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.agentWaiting$str(), (Object)agentReference, (Object)shardAssignment, (Object)clusterDescriptor);
    }

    protected String agentWaiting$str() {
        return "HSEARCH850041: Agent '%s': waiting for cluster changes. Shard assignment: %s. Cluster: %s";
    }

    @Override
    public final void agentRunning(AgentReference agentReference, ShardAssignmentDescriptor shardAssignment, ClusterDescriptor clusterDescriptor) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.agentRunning$str(), (Object)agentReference, (Object)shardAssignment, (Object)clusterDescriptor);
    }

    protected String agentRunning$str() {
        return "HSEARCH850042: Agent '%s': running. Shard assignment: %s. Cluster: %s";
    }

    @Override
    public final void agentPulseStarting(AgentReference agentReference, Instant now, Agent self, List<Agent> allAgentsInIdOrder) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.agentPulseStarting$str(), new Object[]{agentReference, now, self, allAgentsInIdOrder});
    }

    protected String agentPulseStarting$str() {
        return "HSEARCH850043: Agent '%s': starting pulse at %s with self = %s, all agents = %s";
    }

    @Override
    public final void agentPulseEnded(AgentReference agentReference, Instant now, Agent self) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.agentPulseEnded$str(), (Object)agentReference, (Object)now, (Object)self);
    }

    protected String agentPulseEnded$str() {
        return "HSEARCH850044: Agent '%s': ending pulse at %s with self = %s";
    }

    @Override
    public final void agentReassessing(AgentReference agentReference) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.agentReassessing$str(), (Object)agentReference);
    }

    protected String agentReassessing$str() {
        return "HSEARCH850045: Agent '%s': reassessing the new situation in the next pulse";
    }

    @Override
    public final void processingOutboxEvents(int size, String name, List<OutboxEvent> events) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.processingOutboxEvents$str(), (Object)size, (Object)name, events);
    }

    protected String processingOutboxEvents$str() {
        return "HSEARCH850046: Processing %d outbox events for '%s': '%s'";
    }

    @Override
    public final void agentWaitingForEvents(AgentReference agentReference, AgentReference reference, AgentState expectedState) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.agentWaitingForEvents$str(), (Object)agentReference, (Object)reference, (Object)expectedState);
    }

    protected String agentWaitingForEvents$str() {
        return "HSEARCH850047: Agent '%s': waiting for event processor '%s', which has not reached state '%s' yet";
    }

    @Override
    public final void agentProcessorsExpired(AgentReference agentReference, AgentState expectedState) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.agentProcessorsExpired$str(), (Object)agentReference, (Object)expectedState);
    }

    protected String agentProcessorsExpired$str() {
        return "HSEARCH850048: Agent '%s': all event processors reached the expected state %s";
    }

    @Override
    public final void agentHoldMassIndexing(AgentReference agentReference, Duration delay, Instant expiration) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.agentHoldMassIndexing$str(), (Object)agentReference, (Object)delay, (Object)expiration);
    }

    protected String agentHoldMassIndexing$str() {
        return "HSEARCH850049: Agent '%s': instructions are to hold off mass indexing and to retry a pulse in %s, around %s";
    }

    @Override
    public final void agentProceedMassIndexing(AgentReference agentReference, Duration pulseInterval, Instant expiration) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.agentProceedMassIndexing$str(), (Object)agentReference, (Object)pulseInterval, (Object)expiration);
    }

    protected String agentProceedMassIndexing$str() {
        return "HSEARCH850050: Agent '%s': instructions are to proceed with mass indexing and to retry a pulse in %s, around %s";
    }

    @Override
    public final void agentAssignmentDoesNotMatchTarget(AgentReference agentReference, ShardAssignmentDescriptor persistedShardAssignment, ShardAssignmentDescriptor targetShardAssignment, ClusterDescriptor descriptor) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.agentAssignmentDoesNotMatchTarget$str(), new Object[]{agentReference, persistedShardAssignment, targetShardAssignment, descriptor});
    }

    protected String agentAssignmentDoesNotMatchTarget$str() {
        return "HSEARCH850051: Agent '%s': the persisted shard assignment (%s) does not match the target. Target assignment: %s. Cluster: %s.";
    }

    @Override
    public final void agentAssignment(AgentReference agentReference, ShardAssignmentDescriptor targetShardAssignment) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.agentAssignment$str(), (Object)agentReference, (Object)targetShardAssignment);
    }

    protected String agentAssignment$str() {
        return "HSEARCH850052: Agent '%s': assigning to %s";
    }

    @Override
    public final void agentWaitingAgentReachState(AgentReference agentReference, AgentReference reference, AgentState expectedState) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.agentWaitingAgentReachState$str(), (Object)agentReference, (Object)reference, (Object)expectedState);
    }

    protected String agentWaitingAgentReachState$str() {
        return "HSEARCH850053: Agent '%s': waiting for agent '%s', which has not reached state '%s' yet";
    }

    @Override
    public final void agentExcluded(AgentReference agentReference, AgentState expectedState) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.agentExcluded$str(), (Object)agentReference, (Object)expectedState);
    }

    protected String agentExcluded$str() {
        return "HSEARCH850054: Agent '%s': agents excluded from the cluster reached the expected state %s";
    }

    @Override
    public final void instructCommitAndRetryPulseAfterDelay(AgentReference agentReference, Duration delay, Instant expiration) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.instructCommitAndRetryPulseAfterDelay$str(), (Object)agentReference, (Object)delay, (Object)expiration);
    }

    protected String instructCommitAndRetryPulseAfterDelay$str() {
        return "HSEARCH850055: Agent '%s': instructions are to not process events and to retry a pulse in %s, around %s";
    }

    @Override
    public final void instructProceedWithEventProcessing(AgentReference agentReference, Duration pulseInterval, Instant expiration) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.instructProceedWithEventProcessing$str(), (Object)agentReference, (Object)pulseInterval, (Object)expiration);
    }

    protected String instructProceedWithEventProcessing$str() {
        return "HSEARCH850056: Agent '%s': instructions are to process events and to retry a pulse in %s, around %s";
    }

    @Override
    public final void clusterMembersAreInClusterWaitingForState(AgentReference agentReference, AgentReference reference, AgentState state, Set<AgentState> expectedStates) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.clusterMembersAreInClusterWaitingForState$str(), new Object[]{agentReference, reference, state, expectedStates});
    }

    protected String clusterMembersAreInClusterWaitingForState$str() {
        return "HSEARCH850057: Agent '%s': waiting for agent '%s', whose state %s is not in the expected %s yet";
    }

    @Override
    public final void clusterMembersAreInClusterShardCountExpectation(AgentReference agentReference, AgentReference reference, Integer totalShardCount, int expectedTotalShardCount) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.clusterMembersAreInClusterShardCountExpectation$str(), new Object[]{agentReference, reference, totalShardCount, expectedTotalShardCount});
    }

    protected String clusterMembersAreInClusterShardCountExpectation$str() {
        return "HSEARCH850058: Agent '%s': waiting for agent '%s', whose total shard count %s is not the expected %s yet";
    }

    @Override
    public final void clusterMembersAreInClusterSharIndexExpectation(AgentReference agentReference, AgentReference reference, Integer assignedShardIndex, int expectedAssignedShardIndex) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.clusterMembersAreInClusterSharIndexExpectation$str(), new Object[]{agentReference, reference, assignedShardIndex, expectedAssignedShardIndex});
    }

    protected String clusterMembersAreInClusterSharIndexExpectation$str() {
        return "HSEARCH850059: Agent '%s': waiting for agent '%s', whose assigned shard index %s is not the expected %s yet";
    }

    @Override
    public final void clusterMembersAreInClusterReachedExpectedStates(AgentReference agentReference, Set<AgentState> expectedStates, ClusterDescriptor clusterDescriptor) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.clusterMembersAreInClusterReachedExpectedStates$str(), (Object)agentReference, expectedStates, (Object)clusterDescriptor);
    }

    protected String clusterMembersAreInClusterReachedExpectedStates$str() {
        return "HSEARCH850060: Agent '%s': all cluster members reached the expected states %s and shard assignment %s";
    }

    @Override
    public final void agentClusterMembersMissingInfo(AgentReference agentReference, ClusterDescriptor descriptor) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.agentClusterMembersMissingInfo$str(), (Object)agentReference, (Object)descriptor);
    }

    protected String agentClusterMembersMissingInfo$str() {
        return "HSEARCH850061: Agent '%s': some cluster members are missing; this agent will wait until they are present. Target cluster: %s.";
    }

    @Override
    public final void agentClusterMembersMissingTrace(AgentReference agentReference, ClusterDescriptor descriptor) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.agentClusterMembersMissingTrace$str(), (Object)agentReference, (Object)descriptor);
    }

    protected String agentClusterMembersMissingTrace$str() {
        return "HSEARCH850062: Agent '%s': some cluster members are missing; this agent will wait until they are present. Target cluster: %s.";
    }

    @Override
    public final void agentSuperfluousInfo(AgentReference agentReference, ClusterDescriptor descriptor) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.agentSuperfluousInfo$str(), (Object)agentReference, (Object)descriptor);
    }

    protected String agentSuperfluousInfo$str() {
        return "HSEARCH850063: Agent '%s': this agent is superfluous and will not perform event processing, because other agents are enough to handle all the shards. Target cluster: %s.";
    }

    @Override
    public final void agentSuperfluousTrace(AgentReference agentReference, ClusterDescriptor descriptor) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.agentSuperfluousTrace$str(), (Object)agentReference, (Object)descriptor);
    }

    protected String agentSuperfluousTrace$str() {
        return "HSEARCH850064: Agent '%s': this agent is superfluous and will not perform event processing, because other agents are enough to handle all the shards. Target cluster: %s.";
    }

    @Override
    public final void agentOtherAgentIsIndexingInfo(AgentReference agentReference, Agent agent) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.agentOtherAgentIsIndexingInfo$str(), (Object)agentReference, (Object)agent);
    }

    protected String agentOtherAgentIsIndexingInfo$str() {
        return "HSEARCH850065: Agent '%s': another agent '%s' is currently mass indexing";
    }

    @Override
    public final void agentOtherAgentIsIndexingTrace(AgentReference agentReference, Agent agent) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.agentOtherAgentIsIndexingTrace$str(), (Object)agentReference, (Object)agent);
    }

    protected String agentOtherAgentIsIndexingTrace$str() {
        return "HSEARCH850066: Agent '%s': another agent '%s' is currently mass indexing";
    }

    @Override
    public final void eventPlanNumberOfPersistedEvents(int size, List<OutboxEvent> events) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.eventPlanNumberOfPersistedEvents$str(), (Object)size, events);
    }

    protected String eventPlanNumberOfPersistedEvents$str() {
        return "HSEARCH850067: Persisted %d outbox events: '%s'";
    }

    @Override
    public final void eventLockingRetryLimitReached(AgentReference agentReference, int numberOfRetries, Set<UUID> events) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.eventLockingRetryLimitReached$str(), (Object)agentReference, (Object)numberOfRetries, events);
    }

    protected String eventLockingRetryLimitReached$str() {
        return "HSEARCH850070: Agent '%s': after %d retries, failed to acquire a lock on the following outbox events: %s. Events will be re-processed at a later time.";
    }
}

