/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.timerservice.composite;

import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.timerservice.composite.CompositeTimerServiceConfiguration;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimer;
import org.jboss.as.ejb3.timerservice.spi.ManagedTimerService;
import org.jboss.as.ejb3.timerservice.spi.TimedObjectInvoker;
import org.jboss.as.ejb3.timerservice.spi.TimerServiceRegistry;

public class CompositeTimerService
implements ManagedTimerService {
    private final TimedObjectInvoker invoker;
    private final TimerServiceRegistry registry;
    private final ManagedTimerService transientTimerService;
    private final ManagedTimerService persistentTimerService;

    public CompositeTimerService(CompositeTimerServiceConfiguration configuration) {
        this.invoker = configuration.getInvoker();
        this.registry = configuration.getTimerServiceRegistry();
        this.transientTimerService = configuration.getTransientTimerService();
        this.persistentTimerService = configuration.getPersistentTimerService();
    }

    @Override
    public TimedObjectInvoker getInvoker() {
        return this.invoker;
    }

    public boolean isStarted() {
        return this.transientTimerService.isStarted() && this.persistentTimerService.isStarted();
    }

    public void start() {
        this.transientTimerService.start();
        this.persistentTimerService.start();
    }

    public void stop() {
        this.persistentTimerService.stop();
        this.transientTimerService.stop();
    }

    @Override
    public void close() {
        this.persistentTimerService.close();
        this.transientTimerService.close();
    }

    private ManagedTimerService getTimerService(TimerConfig config) {
        return config.isPersistent() ? this.persistentTimerService : this.transientTimerService;
    }

    public Timer createCalendarTimer(ScheduleExpression schedule, TimerConfig config) {
        this.validateInvocationContext();
        if (schedule == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerParameter("schedule", null);
        }
        TimerConfig timerConfig = config != null ? config : new TimerConfig();
        return this.getTimerService(timerConfig).createCalendarTimer(schedule, timerConfig);
    }

    public Timer createIntervalTimer(Date initialExpiration, long intervalDuration, TimerConfig config) {
        this.validateInvocationContext();
        if (initialExpiration == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerParameter("initialExpiration", null);
        }
        if (initialExpiration.getTime() < 0L) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerParameter("initialExpiration.getTime()", Long.toString(initialExpiration.getTime()));
        }
        if (intervalDuration < 0L) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerParameter("intervalDuration", Long.toString(intervalDuration));
        }
        TimerConfig timerConfig = config != null ? config : new TimerConfig();
        return this.getTimerService(timerConfig).createIntervalTimer(initialExpiration, intervalDuration, timerConfig);
    }

    public Timer createSingleActionTimer(Date expiration, TimerConfig config) {
        this.validateInvocationContext();
        if (expiration == null) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerParameter("expiration", null);
        }
        if (expiration.getTime() < 0L) {
            throw EjbLogger.EJB3_TIMER_LOGGER.invalidTimerParameter("expiration.getTime()", Long.toString(expiration.getTime()));
        }
        TimerConfig timerConfig = config != null ? config : new TimerConfig();
        return this.getTimerService(timerConfig).createSingleActionTimer(expiration, timerConfig);
    }

    public Collection<Timer> getTimers() {
        Collection transientTimers = this.transientTimerService.getTimers();
        Collection persistentTimers = this.persistentTimerService.getTimers();
        ArrayList result = new ArrayList(transientTimers.size() + persistentTimers.size());
        result.addAll(transientTimers);
        result.addAll(persistentTimers);
        return Collections.unmodifiableCollection(result);
    }

    public Collection<Timer> getAllTimers() {
        return this.registry.getAllTimers();
    }

    @Override
    public ManagedTimer findTimer(String id) {
        ManagedTimer timer = this.transientTimerService.findTimer(id);
        if (timer == null) {
            timer = this.persistentTimerService.findTimer(id);
        }
        return timer;
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.invoker.getTimedObjectId());
    }
}

