/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.transaction;

import io.undertow.client.ClientRequest;
import jakarta.transaction.SystemException;
import java.net.URI;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLContext;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.HttpMarshallerFactory;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.transaction.ClientHandlers;
import org.wildfly.httpclient.transaction.Constants;
import org.wildfly.httpclient.transaction.HttpRemoteTransactionHandle;
import org.wildfly.httpclient.transaction.HttpSubordinateTransactionHandle;
import org.wildfly.httpclient.transaction.RequestBuilder;
import org.wildfly.httpclient.transaction.RequestType;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.transaction.client.spi.RemoteTransactionPeer;
import org.wildfly.transaction.client.spi.SimpleTransactionControl;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;

public class HttpRemoteTransactionPeer
implements RemoteTransactionPeer {
    private static final AuthenticationContextConfigurationClient CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final HttpTargetContext targetContext;
    private final SSLContext sslContext;
    private final AuthenticationConfiguration authenticationConfiguration;
    private final AuthenticationContext authenticationContext;

    public HttpRemoteTransactionPeer(HttpTargetContext targetContext, SSLContext sslContext, AuthenticationConfiguration authenticationConfiguration) {
        this.targetContext = targetContext;
        this.sslContext = sslContext;
        this.authenticationConfiguration = authenticationConfiguration;
        this.authenticationContext = AuthenticationContext.captureCurrent();
    }

    public SubordinateTransactionControl lookupXid(Xid xid) throws XAException {
        try {
            return new HttpSubordinateTransactionHandle(xid, this.targetContext, this.getSslContext(this.targetContext.getUri()), this.authenticationConfiguration);
        }
        catch (GeneralSecurityException e) {
            XAException xaException = new XAException(-7);
            xaException.initCause(e);
            throw xaException;
        }
    }

    public Xid[] recover(int flag, String parentName) throws XAException {
        SSLContext sslContext;
        RequestBuilder builder = new RequestBuilder().setRequestType(RequestType.XA_RECOVER).setVersion(this.targetContext.getProtocolVersion()).setFlags(flag).setParent(parentName);
        ClientRequest request = builder.createRequest(this.targetContext.getUri().getPath());
        AuthenticationConfiguration authenticationConfiguration = this.getAuthenticationConfiguration(this.targetContext.getUri());
        try {
            sslContext = this.getSslContext(this.targetContext.getUri());
        }
        catch (GeneralSecurityException e) {
            XAException xaException = new XAException(-7);
            xaException.initCause(e);
            throw xaException;
        }
        CompletableFuture<Xid[]> result = new CompletableFuture<Xid[]>();
        HttpMarshallerFactory marshallerFactory = this.targetContext.getHttpMarshallerFactory(request);
        Unmarshaller unmarshaller = marshallerFactory.createUnmarshaller(result);
        if (unmarshaller != null) {
            this.targetContext.sendRequest(request, sslContext, authenticationConfiguration, null, ClientHandlers.xidArrayHttpResultHandler(unmarshaller, result), result::completeExceptionally, Constants.NEW_TRANSACTION, null);
        }
        try {
            return (Xid[])result.get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof XAException) {
                throw (XAException)cause;
            }
            XAException xaException = new XAException(-7);
            xaException.initCause(cause);
            throw xaException;
        }
    }

    public SimpleTransactionControl begin(int timeout) throws SystemException {
        SSLContext sslContext;
        RequestBuilder builder = new RequestBuilder().setRequestType(RequestType.UT_BEGIN).setVersion(this.targetContext.getProtocolVersion()).setTimeout(timeout);
        ClientRequest request = builder.createRequest(this.targetContext.getUri().getPath());
        AuthenticationConfiguration authenticationConfiguration = this.getAuthenticationConfiguration(this.targetContext.getUri());
        try {
            sslContext = this.getSslContext(this.targetContext.getUri());
        }
        catch (GeneralSecurityException e) {
            throw new SystemException(e.getMessage());
        }
        CompletableFuture<Xid> result = new CompletableFuture<Xid>();
        HttpMarshallerFactory marshallerFactory = this.targetContext.getHttpMarshallerFactory(request);
        Unmarshaller unmarshaller = marshallerFactory.createUnmarshaller(result);
        if (unmarshaller != null) {
            this.targetContext.sendRequest(request, sslContext, authenticationConfiguration, null, ClientHandlers.xidHttpResultHandler(unmarshaller, result), result::completeExceptionally, Constants.NEW_TRANSACTION, null);
        }
        try {
            Xid xid = (Xid)result.get();
            return new HttpRemoteTransactionHandle(xid, this.targetContext, sslContext, authenticationConfiguration);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            SystemException ex = new SystemException(e.getMessage());
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    private AuthenticationConfiguration getAuthenticationConfiguration(URI location) {
        if (this.authenticationConfiguration == null) {
            return CLIENT.getAuthenticationConfiguration(location, this.authenticationContext, -1, "jta", "jboss");
        }
        return this.authenticationConfiguration;
    }

    private SSLContext getSslContext(URI location) throws GeneralSecurityException {
        if (this.sslContext == null) {
            return CLIENT.getSSLContext(location, this.authenticationContext, "jta", "jboss");
        }
        return this.sslContext;
    }
}

