/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.expiration;

import java.time.Instant;
import java.util.Optional;
import org.wildfly.clustering.server.expiration.Expiration;

public interface ExpirationMetaData
extends Expiration {
    default public boolean isExpired() {
        Optional<Instant> expirationTime = this.getExpirationTime();
        return expirationTime.isPresent() && !expirationTime.get().isAfter(Instant.now());
    }

    default public Optional<Instant> getExpirationTime() {
        if (this.isImmortal()) {
            return Optional.empty();
        }
        Instant lastAccessedTime = this.getLastAccessTime();
        return lastAccessedTime != null ? Optional.of(lastAccessedTime.plus(this.getTimeout())) : Optional.empty();
    }

    public Instant getLastAccessTime();
}

