/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.internal;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.hibernate.models.internal.util.CollectionHelper;
import org.hibernate.models.jandex.spi.JandexModelsContext;
import org.hibernate.models.jandex.spi.JandexValueExtractor;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.ModelsContext;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;

public class AnnotationUsageBuilder {
    public static final DotName REPEATABLE = DotName.createSimple(Repeatable.class);
    public static final DotName TARGET = DotName.createSimple(Target.class);
    public static final DotName RETENTION = DotName.createSimple(Retention.class);
    public static final DotName DOCUMENTED = DotName.createSimple(Documented.class);

    public static Map<Class<? extends Annotation>, ? extends Annotation> collectUsages(AnnotationTarget jandexAnnotationTarget, ModelsContext modelsContext) {
        if (jandexAnnotationTarget == null) {
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        AnnotationUsageBuilder.processAnnotations(jandexAnnotationTarget.declaredAnnotations(), result::put, modelsContext);
        return result;
    }

    public static void processAnnotations(Collection<AnnotationInstance> annotations, BiConsumer<Class<? extends Annotation>, Annotation> consumer, ModelsContext modelsContext) {
        AnnotationDescriptorRegistry annotationDescriptorRegistry = modelsContext.getAnnotationDescriptorRegistry();
        for (AnnotationInstance annotation : annotations) {
            if (annotation.name().equals((Object)DOCUMENTED) || annotation.name().equals((Object)REPEATABLE) || annotation.name().equals((Object)RETENTION) || annotation.name().equals((Object)TARGET)) continue;
            Class annotationType = modelsContext.getClassLoading().classForName(annotation.name().toString());
            AnnotationDescriptor annotationDescriptor = annotationDescriptorRegistry.getDescriptor(annotationType);
            Object usage = AnnotationUsageBuilder.makeUsage(annotation, annotationDescriptor, modelsContext);
            consumer.accept(annotationType, (Annotation)usage);
        }
    }

    public static <A extends Annotation> A makeUsage(AnnotationInstance jandexAnnotation, AnnotationDescriptor<A> annotationDescriptor, ModelsContext modelContext) {
        Map<String, Object> attributeValues = AnnotationUsageBuilder.extractAttributeValues(jandexAnnotation, annotationDescriptor, modelContext);
        return (A)annotationDescriptor.createUsage(attributeValues, modelContext);
    }

    public static <A extends Annotation> Map<String, Object> extractAttributeValues(AnnotationInstance annotationInstance, AnnotationDescriptor<A> annotationDescriptor, ModelsContext modelContext) {
        if (CollectionHelper.isEmpty((Collection)annotationDescriptor.getAttributes())) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<String, Object> valueMap = new ConcurrentHashMap<String, Object>();
        for (int i = 0; i < annotationDescriptor.getAttributes().size(); ++i) {
            AttributeDescriptor attributeDescriptor = (AttributeDescriptor)annotationDescriptor.getAttributes().get(i);
            JandexValueExtractor extractor = ((JandexModelsContext)modelContext.as(JandexModelsContext.class)).getJandexValueExtractor(attributeDescriptor.getTypeDescriptor());
            Object attributeValue = extractor.extractValue(annotationInstance, attributeDescriptor, modelContext);
            valueMap.put(attributeDescriptor.getName(), attributeValue);
        }
        return valueMap;
    }

    private AnnotationUsageBuilder() {
    }
}

