/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.jandex.internal;

import org.hibernate.models.UnknownClassException;
import org.hibernate.models.internal.AbstractClassDetailsRegistry;
import org.hibernate.models.internal.jdk.JdkBuilders;
import org.hibernate.models.internal.jdk.JdkClassDetails;
import org.hibernate.models.jandex.internal.JandexClassDetailsBuilderImpl;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsBuilder;
import org.hibernate.models.spi.ModelsContext;
import org.jboss.jandex.IndexView;

public class JandexClassDetailsRegistry
extends AbstractClassDetailsRegistry {
    private final IndexView jandexIndex;
    private final ClassDetailsBuilder classDetailsBuilder;

    public JandexClassDetailsRegistry(IndexView jandexIndex, boolean trackImplementors, ModelsContext context) {
        super(trackImplementors, context);
        this.jandexIndex = jandexIndex;
        this.classDetailsBuilder = new JandexClassDetailsBuilderImpl(jandexIndex, context);
    }

    public IndexView getJandexIndex() {
        return this.jandexIndex;
    }

    public ClassDetailsBuilder getClassDetailsBuilder() {
        return this.classDetailsBuilder;
    }

    protected ClassDetails createClassDetails(String name) {
        ClassDetails fromJandex = this.classDetailsBuilder.buildClassDetails(name, this.context);
        if (fromJandex != null) {
            this.addClassDetails(name, fromJandex);
            return fromJandex;
        }
        JdkClassDetails jdkClassDetails = JdkBuilders.DEFAULT_BUILDER.buildClassDetails(name, this.context);
        if (jdkClassDetails != null) {
            this.addClassDetails(name, (ClassDetails)jdkClassDetails);
            return jdkClassDetails;
        }
        throw new UnknownClassException("Unable to resolve ClassDetails for `" + name + "`");
    }
}

