/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.ls.LSInput;
import org.xml.sax.SAXException;

public class XmlProvider {
    public static final String ARTEMIS_DISABLE_XXE_PROPERTY = "artemis.disableXxe";
    public static final String XINCLUDE_AWARE_PROPERTY = "XINCLUDE_AWARE";
    public static final String NAMESPACE_AWARE_PROPERTY = "NAMESPACE_AWARE";
    public static final String IGNORE_COMMENTS_PROPERTY = "IGNORE_COMMENTS";
    public static final String IGNORE_ELEMENT_CONTENT_WHITESPACE_PROPERTY = "IGNORE_ELEMENT_CONTENT_WHITESPACE";
    private static final String ACTIVEMQ_CORE_NS = "urn:activemq:core";
    private static final String ACTIVEMQ_JMS_NS = "urn:activemq:jms";
    private static final String ARTEMIS_XML_SCHEMA_SID = "xml.xsd";
    private static final String ARTEMIS_CONFIGURATION_SCHEMA_SID = "artemis-configuration.xsd";
    private static final String ARTEMIS_JMS_SCHEMA_SID = "artemis-jms.xsd";
    private static final String ARTEMIS_SCHEMA_BASE_URL = "schema/";
    private static final String ARTEMIS_XML_SCHEMA_URL = "schema/xml.xsd";
    private static final String ARTEMIS_CONFIGURATION_SCHEMA_URL = "schema/artemis-configuration.xsd";
    private static final String ARTEMIS_JMS_SCHEMA_URL = "schema/artemis-jms.xsd";
    private static boolean xxeEnabled = !"".equals(System.getProperty("artemis.disableXxe")) && !Boolean.parseBoolean(System.getProperty("artemis.disableXxe", Boolean.FALSE.toString()));

    public static boolean isXxeEnabled() {
        return xxeEnabled;
    }

    public static void setXxeEnabled(boolean enabled) {
        xxeEnabled = enabled;
    }

    public static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        return XmlProvider.newDocumentBuilder(null, null);
    }

    public static DocumentBuilder newDocumentBuilder(Map<String, Boolean> features, Map<String, Boolean> properties) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (features != null) {
            for (Map.Entry<String, Boolean> feature : features.entrySet()) {
                factory.setFeature(feature.getKey(), feature.getValue());
            }
        }
        if (properties != null) {
            for (Map.Entry<String, Boolean> property : properties.entrySet()) {
                if (XINCLUDE_AWARE_PROPERTY.equals(property.getKey())) {
                    factory.setXIncludeAware(property.getValue());
                    continue;
                }
                if (NAMESPACE_AWARE_PROPERTY.equals(property.getKey())) {
                    factory.setNamespaceAware(property.getValue());
                    continue;
                }
                if (IGNORE_COMMENTS_PROPERTY.equals(property.getKey())) {
                    factory.setIgnoringComments(property.getValue());
                    continue;
                }
                if (IGNORE_ELEMENT_CONTENT_WHITESPACE_PROPERTY.equals(property.getKey())) {
                    factory.setIgnoringElementContentWhitespace(property.getValue());
                    continue;
                }
                throw new IllegalArgumentException("Property not supported: " + property.getKey());
            }
        }
        if (!XmlProvider.isXxeEnabled()) {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
        }
        return factory.newDocumentBuilder();
    }

    public static XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        if (!XmlProvider.isXxeEnabled()) {
            xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        }
        return xmlInputFactory.createXMLStreamReader(inputStream);
    }

    public static Schema newSchema(Source schema, Map<String, Boolean> features) throws SAXException {
        return XmlProvider.newSchemaFactory(features).newSchema(schema);
    }

    private static SchemaFactory newSchemaFactory(Map<String, Boolean> features) throws SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (features != null) {
            for (Map.Entry<String, Boolean> feature : features.entrySet()) {
                factory.setFeature(feature.getKey(), feature.getValue());
            }
        }
        if (!XmlProvider.isXxeEnabled()) {
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            factory.setResourceResolver((type, namespaceURI, publicId, systemId, baseURI) -> {
                if ("http://www.w3.org/2001/XMLSchema".equals(type) && "http://www.w3.org/XML/1998/namespace".equals(namespaceURI) && ARTEMIS_XML_SCHEMA_SID.equals(systemId)) {
                    return XmlProvider.newLSInput(publicId, systemId, baseURI, Thread.currentThread().getContextClassLoader().getResourceAsStream(ARTEMIS_XML_SCHEMA_URL));
                }
                if ("http://www.w3.org/2001/XMLSchema".equals(type) && ACTIVEMQ_CORE_NS.equals(namespaceURI) && ARTEMIS_CONFIGURATION_SCHEMA_SID.equals(systemId)) {
                    return XmlProvider.newLSInput(publicId, systemId, baseURI, Thread.currentThread().getContextClassLoader().getResourceAsStream(ARTEMIS_CONFIGURATION_SCHEMA_URL));
                }
                if ("http://www.w3.org/2001/XMLSchema".equals(type) && ACTIVEMQ_JMS_NS.equals(namespaceURI) && ARTEMIS_JMS_SCHEMA_SID.equals(systemId)) {
                    return XmlProvider.newLSInput(publicId, systemId, baseURI, Thread.currentThread().getContextClassLoader().getResourceAsStream(ARTEMIS_JMS_SCHEMA_URL));
                }
                return null;
            });
        }
        return factory;
    }

    public static Transformer newTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (!XmlProvider.isXxeEnabled()) {
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        return transformerFactory.newTransformer();
    }

    public static Validator newValidator(URL schema) throws SAXException {
        Validator validator = XmlProvider.newSchemaFactory(null).newSchema(schema).newValidator();
        if (!XmlProvider.isXxeEnabled()) {
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        return validator;
    }

    private static LSInput newLSInput(final String publicId, final String systemId, final String baseURI, final InputStream byteStream) {
        return new LSInput(){

            @Override
            public Reader getCharacterStream() {
                return null;
            }

            @Override
            public void setCharacterStream(Reader reader) {
            }

            @Override
            public InputStream getByteStream() {
                return byteStream;
            }

            @Override
            public void setByteStream(InputStream inputStream) {
            }

            @Override
            public String getStringData() {
                return null;
            }

            @Override
            public void setStringData(String s) {
            }

            @Override
            public String getSystemId() {
                return systemId;
            }

            @Override
            public void setSystemId(String s) {
            }

            @Override
            public String getPublicId() {
                return publicId;
            }

            @Override
            public void setPublicId(String s) {
            }

            @Override
            public String getBaseURI() {
                return baseURI;
            }

            @Override
            public void setBaseURI(String s) {
            }

            @Override
            public String getEncoding() {
                return null;
            }

            @Override
            public void setEncoding(String s) {
            }

            @Override
            public boolean getCertifiedText() {
                return false;
            }

            @Override
            public void setCertifiedText(boolean b) {
            }
        };
    }
}

