/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.stork.api.observability;

import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.api.observability.StorkEventHandler;
import java.time.Duration;
import java.util.List;

public class StorkObservation {
    private final StorkEventHandler handler;
    private final String serviceName;
    private final String serviceDiscoveryType;
    private final String serviceSelectionType;
    private final long begin;
    private volatile long endOfServiceDiscovery;
    private volatile long endOfServiceSelection;
    private volatile int instancesCount = -1;
    private volatile long selectedInstanceId = -1L;
    private volatile boolean done;
    private volatile boolean serviceDiscoverySuccessful = false;
    private volatile Throwable failure;

    public StorkObservation(String serviceName, String serviceDiscoveryType, String serviceSelectionType, StorkEventHandler handler) {
        this.handler = handler;
        this.serviceName = serviceName;
        this.serviceDiscoveryType = serviceDiscoveryType;
        this.serviceSelectionType = serviceSelectionType;
        this.begin = System.nanoTime();
    }

    public void onServiceDiscoverySuccess(List<ServiceInstance> instances) {
        this.endOfServiceDiscovery = System.nanoTime();
        this.serviceDiscoverySuccessful = true;
        this.instancesCount = instances != null ? instances.size() : 0;
    }

    public void onServiceDiscoveryFailure(Throwable throwable) {
        this.endOfServiceDiscovery = System.nanoTime();
        this.failure = throwable;
    }

    public void onServiceSelectionSuccess(long id) {
        this.endOfServiceSelection = System.nanoTime();
        this.selectedInstanceId = id;
        this.done = true;
        this.handler.complete(this);
    }

    public void onServiceSelectionFailure(Throwable throwable) {
        this.endOfServiceSelection = System.nanoTime();
        if (this.failure != throwable) {
            this.failure = throwable;
        }
        this.handler.complete(this);
    }

    public boolean isDone() {
        return this.done || this.failure != null;
    }

    public Duration getOverallDuration() {
        if (!this.isDone()) {
            return null;
        }
        return Duration.ofNanos(this.endOfServiceSelection - this.begin);
    }

    public Duration getServiceDiscoveryDuration() {
        return Duration.ofNanos(this.endOfServiceDiscovery - this.begin);
    }

    public Duration getServiceSelectionDuration() {
        if (!this.isDone()) {
            return null;
        }
        return Duration.ofNanos(this.endOfServiceSelection - this.endOfServiceDiscovery);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceDiscoveryType() {
        return this.serviceDiscoveryType;
    }

    public String getServiceSelectionType() {
        return this.serviceSelectionType;
    }

    public int getDiscoveredInstancesCount() {
        return this.instancesCount;
    }

    public Throwable failure() {
        return this.failure;
    }

    public boolean isServiceDiscoverySuccessful() {
        return this.serviceDiscoverySuccessful;
    }
}

