/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeLinkConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSender;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeSenderConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeToPolicyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQPBridgeSenderManager {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AMQPBridgeManager bridgeManager;
    private final AMQPBridgeToPolicyManager policyManager;
    private final AMQPBridgeSenderConfiguration configuration;
    private State state = State.READY;
    private AMQPBridgeSender sender;
    private AMQPBridgeSenderRecoveryHandler recoveryHandler;

    public AMQPBridgeSenderManager(AMQPBridgeToPolicyManager policyManager, AMQPBridgeSenderConfiguration configuration) {
        this.policyManager = policyManager;
        this.configuration = configuration;
        this.bridgeManager = policyManager.getBridgeManager();
    }

    protected abstract AMQPBridgeSender createBridgeSender();

    public void shutdownNow() {
        if (this.state != State.CLOSED) {
            this.state = State.CLOSED;
            try {
                if (this.sender != null) {
                    this.safeCloseCurrentBridgeSender();
                }
            }
            finally {
                this.sender = null;
                this.closeRecoveryHandler();
            }
        }
    }

    public void start() {
        this.checkClosed();
        if (this.state == State.READY) {
            this.tryCreateBridgeSender();
        }
    }

    private void tryCreateBridgeSender() {
        this.state = State.STARTING;
        this.sender = this.createBridgeSender();
        logger.trace("Bridge sender manager creating remote sender for: {}", (Object)this.sender.getSenderInfo());
        this.sender.setRemoteOpenHandler(openedSender -> {
            AMQPBridgeToPolicyManager aMQPBridgeToPolicyManager = this.policyManager;
            synchronized (aMQPBridgeToPolicyManager) {
                if (this.state == State.STARTING) {
                    this.state = State.STARTED;
                }
                this.closeRecoveryHandler();
            }
        });
        this.sender.setRemoteClosedHandler(closedSender -> {
            AMQPBridgeSenderManager aMQPBridgeSenderManager = this;
            synchronized (aMQPBridgeSenderManager) {
                AMQPBridgeToPolicyManager aMQPBridgeToPolicyManager = this.policyManager;
                synchronized (aMQPBridgeToPolicyManager) {
                    this.safeCloseCurrentBridgeSender();
                    if (this.configuration.isLinkRecoveryEnabled() && this.state == State.READY) {
                        boolean scheduled;
                        if (this.recoveryHandler == null) {
                            this.recoveryHandler = new AMQPBridgeSenderRecoveryHandler(this, this.configuration);
                        }
                        if (!(scheduled = this.recoveryHandler.tryScheduleNextRecovery(this.bridgeManager.getScheduler()))) {
                            this.closeRecoveryHandler();
                        }
                    }
                }
            }
        });
        this.sender.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryRecoverSender() {
        AMQPBridgeToPolicyManager aMQPBridgeToPolicyManager = this.policyManager;
        synchronized (aMQPBridgeToPolicyManager) {
            if (this.state == State.READY) {
                this.tryCreateBridgeSender();
            } else {
                this.closeRecoveryHandler();
            }
        }
    }

    private void safeCloseCurrentBridgeSender() {
        try {
            this.safeCloseCurrentBridgeSender(this.sender);
            this.state = this.state == State.CLOSED ? State.CLOSED : State.READY;
        }
        catch (Throwable throwable) {
            this.state = this.state == State.CLOSED ? State.CLOSED : State.READY;
            this.sender = null;
            throw throwable;
        }
        this.sender = null;
    }

    private void safeCloseCurrentBridgeSender(AMQPBridgeSender sender) {
        if (sender != null) {
            try {
                if (!sender.isClosed()) {
                    sender.close();
                }
            }
            catch (Exception e) {
                logger.trace("Suppressed error on close of bridge sender. ", (Throwable)e);
            }
        }
    }

    private void checkClosed() {
        if (this.state == State.CLOSED) {
            throw new IllegalStateException("The bridge sender has been closed already");
        }
    }

    private void closeRecoveryHandler() {
        if (this.recoveryHandler != null) {
            try {
                this.recoveryHandler.close();
            }
            finally {
                this.recoveryHandler = null;
            }
        }
    }

    private static enum State {
        READY,
        STARTING,
        STARTED,
        CLOSED;

    }

    public static class AMQPBridgeSenderRecoveryHandler
    implements Closeable {
        private final AMQPBridgeSenderManager manager;
        private final AMQPBridgeLinkConfiguration configuration;
        private final int maxRecoveryAttempts;
        private final AtomicInteger recoveryAttempts = new AtomicInteger();
        private final AtomicLong nextRecoveryDelay = new AtomicLong();
        private volatile ScheduledFuture<?> recoveryFuture;

        public AMQPBridgeSenderRecoveryHandler(AMQPBridgeSenderManager manager, AMQPBridgeLinkConfiguration configuration) {
            this.manager = manager;
            this.configuration = configuration;
            this.nextRecoveryDelay.set(configuration.getLinkRecoveryInitialDelay() > 0L ? configuration.getLinkRecoveryInitialDelay() : 1L);
            this.maxRecoveryAttempts = configuration.getMaxLinkRecoveryAttempts();
        }

        @Override
        public void close() {
            ScheduledFuture<?> future = this.recoveryFuture;
            if (future != null) {
                future.cancel(false);
            }
            this.recoveryFuture = null;
        }

        public boolean tryScheduleNextRecovery(ScheduledExecutorService scheduler) {
            Objects.requireNonNull(scheduler, "The scheduler to use cannot be null");
            if (this.maxRecoveryAttempts < 0 || this.recoveryAttempts.get() < this.maxRecoveryAttempts) {
                this.recoveryFuture = scheduler.schedule(this::handleReconnectionAttempt, this.nextRecoveryDelay.get(), TimeUnit.MILLISECONDS);
                return true;
            }
            return false;
        }

        private void handleReconnectionAttempt() {
            ScheduledFuture<?> future = this.recoveryFuture;
            try {
                if (future != null && !future.isCancelled()) {
                    if (this.maxRecoveryAttempts > 0) {
                        this.recoveryAttempts.incrementAndGet();
                    }
                    this.nextRecoveryDelay.set(this.configuration.getLinkRecoveryDelay() > 0L ? this.configuration.getLinkRecoveryDelay() : 1L);
                    this.manager.tryRecoverSender();
                }
            }
            finally {
                this.recoveryFuture = null;
            }
        }
    }
}

