/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.loading.impl;

import org.hibernate.ObjectNotFoundException;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.search.mapper.orm.loading.impl.EntityLoadingCacheLookupStrategyImplementor;
import org.hibernate.search.mapper.orm.loading.impl.PersistenceContextLookupStrategy;
import org.hibernate.search.mapper.orm.logging.impl.OrmMiscLog;
import org.hibernate.search.util.common.annotation.impl.SuppressForbiddenApis;

@SuppressForbiddenApis(reason="EntityPersister is needed to retrieve/use EntityDataAccess")
abstract class PersistenceContextThenSecondLevelCacheLookupStrategy
implements EntityLoadingCacheLookupStrategyImplementor {
    private final EntityLoadingCacheLookupStrategyImplementor persistenceContextLookupStrategy;
    private final EntityDataAccess cacheAccess;
    protected final EntityPersister persister;
    protected final SessionImplementor session;

    static EntityLoadingCacheLookupStrategyImplementor create(EntityMappingType entityMappingType, SessionImplementor session) {
        PersistenceContextLookupStrategy persistenceContextLookupStrategy = PersistenceContextLookupStrategy.create(session);
        EntityPersister entityPersister = entityMappingType.getEntityPersister();
        EntityDataAccess cacheAccess = entityPersister.getCacheAccessStrategy();
        if (cacheAccess == null) {
            OrmMiscLog.INSTANCE.skippingSecondLevelCacheLookupsForNonCachedEntityTypeEntityLoader(entityPersister.getEntityName());
            return persistenceContextLookupStrategy;
        }
        if (RepresentationMode.MAP.equals((Object)entityMappingType.getRepresentationStrategy().getMode())) {
            return new DynamicMapPersistenceContextThenSecondLevelCacheLookupStrategy(persistenceContextLookupStrategy, entityPersister, cacheAccess, session);
        }
        return new PojoPersistenceContextThenSecondLevelCacheLookupStrategy(persistenceContextLookupStrategy, entityPersister, cacheAccess, session);
    }

    private PersistenceContextThenSecondLevelCacheLookupStrategy(EntityLoadingCacheLookupStrategyImplementor persistenceContextLookupStrategy, EntityPersister persister, EntityDataAccess cacheAccess, SessionImplementor session) {
        this.persistenceContextLookupStrategy = persistenceContextLookupStrategy;
        this.persister = persister;
        this.cacheAccess = cacheAccess;
        this.session = session;
    }

    @Override
    public Object lookup(EntityKey entityKey) {
        Object fromPersistenceContext = this.persistenceContextLookupStrategy.lookup(entityKey);
        if (fromPersistenceContext != null) {
            return fromPersistenceContext;
        }
        Object key = this.cacheAccess.generateCacheKey(entityKey.getIdentifier(), this.persister, this.session.getSessionFactory(), this.session.getTenantIdentifier());
        if (!this.cacheAccess.contains(key)) {
            return null;
        }
        try {
            return this.lookupByIdentifier(entityKey);
        }
        catch (ObjectNotFoundException ignored) {
            return null;
        }
    }

    protected abstract Object lookupByIdentifier(EntityKey var1);

    @SuppressForbiddenApis(reason="EntityPersister is needed to retrieve/use EntityDataAccess")
    private static class DynamicMapPersistenceContextThenSecondLevelCacheLookupStrategy
    extends PersistenceContextThenSecondLevelCacheLookupStrategy {
        private DynamicMapPersistenceContextThenSecondLevelCacheLookupStrategy(EntityLoadingCacheLookupStrategyImplementor persistenceContextLookupStrategy, EntityPersister persister, EntityDataAccess cacheAccess, SessionImplementor session) {
            super(persistenceContextLookupStrategy, persister, cacheAccess, session);
        }

        @Override
        protected Object lookupByIdentifier(EntityKey entityKey) {
            return this.session.find(this.persister.getEntityName(), entityKey.getIdentifier());
        }
    }

    @SuppressForbiddenApis(reason="EntityPersister is needed to retrieve/use EntityDataAccess")
    private static class PojoPersistenceContextThenSecondLevelCacheLookupStrategy
    extends PersistenceContextThenSecondLevelCacheLookupStrategy {
        private PojoPersistenceContextThenSecondLevelCacheLookupStrategy(EntityLoadingCacheLookupStrategyImplementor persistenceContextLookupStrategy, EntityPersister persister, EntityDataAccess cacheAccess, SessionImplementor session) {
            super(persistenceContextLookupStrategy, persister, cacheAccess, session);
        }

        @Override
        protected Object lookupByIdentifier(EntityKey entityKey) {
            return this.session.find(this.persister.getMappedClass(), entityKey.getIdentifier());
        }
    }
}

