/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.model.impl;

import java.lang.annotation.Annotation;
import java.util.stream.Stream;
import org.hibernate.search.mapper.orm.logging.impl.MappingLog;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBasicDynamicMapPropertyMetadata;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmBootstrapIntrospector;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmDynamicMapRawTypeModel;
import org.hibernate.search.mapper.orm.model.impl.HibernateOrmDynamicMapValueReadHandle;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

class HibernateOrmDynamicMapPropertyModel<T>
implements PojoPropertyModel<T> {
    private final HibernateOrmBootstrapIntrospector introspector;
    private final HibernateOrmDynamicMapRawTypeModel holderTypeModel;
    private final String name;
    private final HibernateOrmBasicDynamicMapPropertyMetadata ormPropertyMetadata;
    private ValueReadHandle<T> handle;
    private PojoTypeModel<T> typeModel;

    HibernateOrmDynamicMapPropertyModel(HibernateOrmBootstrapIntrospector introspector, HibernateOrmDynamicMapRawTypeModel holderTypeModel, String name, HibernateOrmBasicDynamicMapPropertyMetadata ormPropertyMetadata) {
        this.introspector = introspector;
        this.holderTypeModel = holderTypeModel;
        this.name = name;
        this.ormPropertyMetadata = ormPropertyMetadata;
    }

    public String name() {
        return this.name;
    }

    public Stream<Annotation> annotations() {
        return Stream.empty();
    }

    public PojoTypeModel<T> typeModel() {
        if (this.typeModel == null) {
            try {
                this.typeModel = this.ormPropertyMetadata.getTypeModelFactory().create(this.introspector);
            }
            catch (RuntimeException e) {
                throw MappingLog.INSTANCE.errorRetrievingPropertyTypeModel(this.name(), (PojoRawTypeModel<?>)this.holderTypeModel, e.getMessage(), e);
            }
        }
        return this.typeModel;
    }

    public ValueReadHandle<T> handle() {
        if (this.handle == null) {
            try {
                this.handle = new HibernateOrmDynamicMapValueReadHandle(this.name, this.typeModel().rawType().typeIdentifier().javaClass());
            }
            catch (RuntimeException e) {
                throw MappingLog.INSTANCE.errorRetrievingPropertyTypeModel(this.name(), (PojoRawTypeModel<?>)this.holderTypeModel, e.getMessage(), e);
            }
        }
        return this.handle;
    }
}

