/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.session.impl;

import jakarta.transaction.Synchronization;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.search.mapper.orm.logging.impl.OrmMiscLog;

class SynchronizationAdapter
implements Synchronization,
BeforeTransactionCompletionProcess,
AfterTransactionCompletionProcess {
    private final Synchronization delegate;
    private boolean beforeExecuted = false;
    private boolean afterExecuted = false;

    SynchronizationAdapter(Synchronization delegate) {
        this.delegate = delegate;
    }

    public void beforeCompletion() {
        this.doBeforeCompletion();
    }

    public void afterCompletion(int status) {
        OrmMiscLog.INSTANCE.syncAdapterIgnoringAfterCompletion(this.delegate);
    }

    public void doBeforeTransactionCompletion(SessionImplementor sessionImplementor) {
        try {
            this.doBeforeCompletion();
        }
        catch (RuntimeException e) {
            throw OrmMiscLog.INSTANCE.synchronizationBeforeTransactionFailure(e.getMessage(), e);
        }
    }

    public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor sessionImplementor) {
        try {
            this.doAfterCompletion(success ? 3 : 4);
        }
        catch (RuntimeException e) {
            throw OrmMiscLog.INSTANCE.synchronizationAfterTransactionFailure(e.getMessage(), e);
        }
    }

    private void doBeforeCompletion() {
        if (this.beforeExecuted) {
            OrmMiscLog.INSTANCE.syncAdapterIgnoringBeforeCompletionAlreadyExecuted(this.delegate);
        } else {
            this.delegate.beforeCompletion();
            this.beforeExecuted = true;
        }
    }

    private void doAfterCompletion(int status) {
        if (this.afterExecuted) {
            OrmMiscLog.INSTANCE.syncAdapterIgnoringAfterCompletionAlreadyExecuted(this.delegate);
        } else {
            this.delegate.afterCompletion(status);
            this.afterExecuted = true;
        }
    }
}

