/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.persistence.jipijapa.hibernate7.cache;

import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.OptionalInt;
import org.hibernate.cache.internal.BasicCacheKeyImplementation;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class BasicCacheKeyImplementationMarshaller
implements ProtoStreamMarshaller<BasicCacheKeyImplementation> {
    private static final int ID_INDEX = 1;
    private static final int ENTITY_INDEX = 2;
    private static final int HASH_CODE_INDEX = 3;

    public Class<? extends BasicCacheKeyImplementation> getJavaClass() {
        return BasicCacheKeyImplementation.class;
    }

    public BasicCacheKeyImplementation readFrom(ProtoStreamReader reader) throws IOException {
        Serializable id = null;
        String entity = null;
        OptionalInt hashCode = OptionalInt.empty();
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    id = (Serializable)reader.readAny(Serializable.class);
                    continue block5;
                }
                case 2: {
                    entity = reader.readString();
                    continue block5;
                }
                case 3: {
                    hashCode = OptionalInt.of(reader.readSFixed32());
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        return new BasicCacheKeyImplementation(id, entity, hashCode.orElse(Objects.hashCode(id)));
    }

    public void writeTo(ProtoStreamWriter writer, BasicCacheKeyImplementation key) throws IOException {
        int hashCode;
        String entity;
        Object id = key.getId();
        if (id != null) {
            writer.writeAny(1, id);
        }
        if ((entity = key.getEntityOrRoleName()) != null) {
            writer.writeString(2, entity);
        }
        if ((hashCode = key.hashCode()) != Objects.hashCode(id)) {
            writer.writeSFixed32(3, hashCode);
        }
    }
}

