/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.spi.interceptor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.LockMode;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.bytecode.enhance.spi.interceptor.AbstractInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.BytecodeLazyAttributeInterceptor;
import org.hibernate.bytecode.enhance.spi.interceptor.EnhancementHelper;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.Status;
import org.hibernate.persister.entity.EntityPersister;

public class LazyAttributeLoadingInterceptor
extends AbstractInterceptor
implements BytecodeLazyAttributeInterceptor {
    private final Object identifier;
    private EntityRelatedState entityMeta;
    private Set<String> initializedLazyFields;

    public LazyAttributeLoadingInterceptor(EntityRelatedState entityMeta, Object identifier, SharedSessionContractImplementor session) {
        this.identifier = identifier;
        this.entityMeta = entityMeta;
        this.setSession(session);
    }

    @Override
    public String getEntityName() {
        return this.entityMeta.entityName;
    }

    @Override
    public Object getIdentifier() {
        return this.identifier;
    }

    @Override
    protected Object handleRead(Object target, String attributeName, Object value) {
        if (!this.isAttributeLoaded(attributeName)) {
            Object loadedValue = this.fetchAttribute(target, attributeName);
            this.attributeInitialized(attributeName);
            return loadedValue;
        }
        return value;
    }

    @Override
    protected Object handleWrite(Object target, String attributeName, Object oldValue, Object newValue) {
        this.attributeInitialized(attributeName);
        return newValue;
    }

    public Object fetchAttribute(Object target, String attributeName) {
        return this.loadAttribute(target, attributeName);
    }

    protected Object loadAttribute(Object target, String attributeName) {
        return EnhancementHelper.performWork(this, (session, isTemporarySession) -> {
            EntityPersister persister = session.getFactory().getMappingMetamodel().getEntityDescriptor(this.getEntityName());
            if (isTemporarySession.booleanValue()) {
                Object id = persister.getIdentifier(target, (SharedSessionContractImplementor)session);
                Object[] loadedState = null;
                boolean existsInDb = true;
                session.getPersistenceContextInternal().addEntity(target, Status.READ_ONLY, loadedState, session.generateEntityKey(id, persister), persister.getVersion(target), LockMode.NONE, true, persister, true);
            }
            LazyPropertyInitializer initializer = (LazyPropertyInitializer)((Object)persister);
            Object loadedValue = initializer.initializeLazyProperty(attributeName, target, (SharedSessionContractImplementor)session);
            this.takeCollectionSizeSnapshot(target, attributeName, loadedValue);
            return loadedValue;
        }, this.getEntityName(), attributeName);
    }

    @Override
    public boolean isAttributeLoaded(String fieldName) {
        return !this.isLazyAttribute(fieldName) || this.isInitializedLazyField(fieldName);
    }

    private boolean isLazyAttribute(String fieldName) {
        return this.entityMeta.lazyFields.contains(fieldName);
    }

    private boolean isInitializedLazyField(String fieldName) {
        return this.initializedLazyFields != null && this.initializedLazyFields.contains(fieldName);
    }

    @Override
    public boolean hasAnyUninitializedAttributes() {
        if (this.entityMeta.lazyFields.isEmpty()) {
            return false;
        }
        if (this.initializedLazyFields == null) {
            return true;
        }
        for (String fieldName : this.entityMeta.lazyFields) {
            if (this.initializedLazyFields.contains(fieldName)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(entityName=" + this.getEntityName() + " ,lazyFields=" + String.valueOf(this.entityMeta.lazyFields) + ")";
    }

    private void takeCollectionSizeSnapshot(Object target, String fieldName, Object value) {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (ManagedTypeHelper.isSelfDirtinessTracker(target)) {
                PersistentCollection persistentCollection;
                SelfDirtinessTracker targetSDT = ManagedTypeHelper.asSelfDirtinessTracker(target);
                CollectionTracker tracker = targetSDT.$$_hibernate_getCollectionTracker();
                if (tracker == null) {
                    targetSDT.$$_hibernate_clearDirtyAttributes();
                    tracker = targetSDT.$$_hibernate_getCollectionTracker();
                }
                if (value instanceof PersistentCollection && !(persistentCollection = (PersistentCollection)value).wasInitialized()) {
                    return;
                }
                tracker.add(fieldName, collection.size());
            }
        }
    }

    @Override
    public void attributeInitialized(String name) {
        if (!this.isLazyAttribute(name)) {
            return;
        }
        if (this.initializedLazyFields == null) {
            this.initializedLazyFields = new HashSet<String>();
        }
        this.initializedLazyFields.add(name);
    }

    @Override
    public Set<String> getInitializedLazyAttributeNames() {
        return this.initializedLazyFields == null ? Collections.emptySet() : this.initializedLazyFields;
    }

    public void addLazyFieldByGraph(String fieldName) {
        if (this.entityMeta.shared) {
            this.entityMeta = this.entityMeta.toNonSharedMutableState();
        }
        this.entityMeta.lazyFields.add(fieldName);
    }

    public void clearInitializedLazyFields() {
        this.initializedLazyFields = null;
    }

    public static class EntityRelatedState {
        private final String entityName;
        private final Set<String> lazyFields;
        private final boolean shared;

        public EntityRelatedState(String entityName, Set<String> lazyFields) {
            this.entityName = entityName;
            this.lazyFields = lazyFields;
            this.shared = true;
        }

        private EntityRelatedState(String entityName, Set<String> lazyFields, boolean shared) {
            this.entityName = entityName;
            this.lazyFields = lazyFields;
            this.shared = shared;
        }

        private EntityRelatedState toNonSharedMutableState() {
            return new EntityRelatedState(this.entityName, new HashSet<String>(this.lazyFields), false);
        }
    }
}

