/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.AssertionFailure;
import org.hibernate.InstantiationException;
import org.hibernate.ScrollMode;
import org.hibernate.engine.spi.EntityHolder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.EmptyScrollableResults;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.QueryTypeMismatchException;
import org.hibernate.query.TupleTransformer;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.SelectQueryPlan;
import org.hibernate.query.sqm.internal.AppliedGraphs;
import org.hibernate.query.sqm.internal.CacheableSqmInterpretation;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmJdbcExecutionContextAdapter;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.spi.SqmParameterMappingModelResolutionAccess;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.internal.SqmParameterInterpretation;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.sql.results.internal.RowTransformerArrayImpl;
import org.hibernate.sql.results.internal.RowTransformerCheckingImpl;
import org.hibernate.sql.results.internal.RowTransformerConstructorImpl;
import org.hibernate.sql.results.internal.RowTransformerJpaTupleImpl;
import org.hibernate.sql.results.internal.RowTransformerListImpl;
import org.hibernate.sql.results.internal.RowTransformerMapImpl;
import org.hibernate.sql.results.internal.RowTransformerSingularReturnImpl;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.internal.RowTransformerTupleTransformerAdapter;
import org.hibernate.sql.results.internal.TupleMetadata;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowTransformer;

public class ConcreteSqmSelectQueryPlan<R>
implements SelectQueryPlan<R> {
    private final SqmSelectStatement<?> sqm;
    private final DomainParameterXref domainParameterXref;
    private final SqmInterpreter<?, ? extends ResultsConsumer<?, R>> executeQueryInterpreter;
    private final SqmInterpreter<List<R>, Void> listInterpreter;
    private final SqmInterpreter<ScrollableResultsImplementor<R>, ScrollMode> scrollInterpreter;
    private volatile CacheableSqmInterpretation<SelectStatement, JdbcOperationQuerySelect> cacheableSqmInterpretation;
    private static final Map<Class<?>, Class<?>> WRAPPERS = Map.of(Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class, Byte.TYPE, Byte.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class);

    public ConcreteSqmSelectQueryPlan(SqmSelectStatement<?> sqm, String hql, DomainParameterXref domainParameterXref, Class<R> resultType, TupleMetadata tupleMetadata, QueryOptions queryOptions) {
        this.sqm = sqm;
        this.domainParameterXref = domainParameterXref;
        ListResultsConsumer.UniqueSemantic uniqueSemantic = sqm.producesUniqueResults() && !AppliedGraphs.containsCollectionFetches(queryOptions) ? ListResultsConsumer.UniqueSemantic.NONE : ListResultsConsumer.UniqueSemantic.ALLOW;
        this.executeQueryInterpreter = (resultsConsumer, executionContext, sqmInterpretation, jdbcParameterBindings) -> {
            SharedSessionContractImplementor session = executionContext.getSession();
            JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)sqmInterpretation.jdbcOperation();
            try {
                SubselectFetch.RegistrationHandler subSelectFetchKeyHandler = SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), (SelectStatement)sqmInterpretation.statement(), JdbcParametersList.empty(), jdbcParameterBindings);
                session.autoFlushIfRequired(jdbcSelect.getAffectedTableNames(), true);
                Expression fetchExpression = ((SelectStatement)sqmInterpretation.statement()).getQueryPart().getFetchClauseExpression();
                int resultCountEstimate = fetchExpression != null ? ConcreteSqmSelectQueryPlan.interpretIntExpression(fetchExpression, jdbcParameterBindings) : -1;
                Object t = session.getFactory().getJdbcServices().getJdbcSelectExecutor().executeQuery(jdbcSelect, jdbcParameterBindings, (ExecutionContext)ConcreteSqmSelectQueryPlan.listInterpreterExecutionContext(hql, executionContext, jdbcSelect, subSelectFetchKeyHandler), ConcreteSqmSelectQueryPlan.determineRowTransformer(sqm, resultType, tupleMetadata, executionContext.getQueryOptions()), null, resultCountEstimate, resultsConsumer);
                return t;
            }
            finally {
                domainParameterXref.clearExpansions();
            }
        };
        this.listInterpreter = (unused, executionContext, sqmInterpretation, jdbcParameterBindings) -> {
            SharedSessionContractImplementor session = executionContext.getSession();
            JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)sqmInterpretation.jdbcOperation();
            try {
                SubselectFetch.RegistrationHandler subSelectFetchKeyHandler = SubselectFetch.createRegistrationHandler(session.getPersistenceContext().getBatchFetchQueue(), (SelectStatement)sqmInterpretation.statement(), JdbcParametersList.empty(), jdbcParameterBindings);
                session.autoFlushIfRequired(jdbcSelect.getAffectedTableNames(), true);
                Expression fetchExpression = ((SelectStatement)sqmInterpretation.statement()).getQueryPart().getFetchClauseExpression();
                int resultCountEstimate = fetchExpression != null ? ConcreteSqmSelectQueryPlan.interpretIntExpression(fetchExpression, jdbcParameterBindings) : -1;
                List list = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParameterBindings, ConcreteSqmSelectQueryPlan.listInterpreterExecutionContext(hql, executionContext, jdbcSelect, subSelectFetchKeyHandler), ConcreteSqmSelectQueryPlan.determineRowTransformer(sqm, resultType, tupleMetadata, executionContext.getQueryOptions()), executionContext.getResultType(), uniqueSemantic, resultCountEstimate);
                return list;
            }
            finally {
                domainParameterXref.clearExpansions();
            }
        };
        this.scrollInterpreter = (scrollMode, executionContext, sqmInterpretation, jdbcParameterBindings) -> {
            SharedSessionContractImplementor session = executionContext.getSession();
            JdbcOperationQuerySelect jdbcSelect = (JdbcOperationQuerySelect)sqmInterpretation.jdbcOperation();
            try {
                JdbcSelectExecutor jdbcSelectExecutor = session.getFactory().getJdbcServices().getJdbcSelectExecutor();
                session.autoFlushIfRequired(jdbcSelect.getAffectedTableNames(), true);
                Expression fetchExpression = ((SelectStatement)sqmInterpretation.statement()).getQueryPart().getFetchClauseExpression();
                int resultCountEstimate = fetchExpression != null ? ConcreteSqmSelectQueryPlan.interpretIntExpression(fetchExpression, jdbcParameterBindings) : -1;
                ScrollableResultsImplementor scrollableResultsImplementor = jdbcSelectExecutor.scroll(jdbcSelect, (ScrollMode)((Object)scrollMode), jdbcParameterBindings, new SqmJdbcExecutionContextAdapter(executionContext, jdbcSelect), ConcreteSqmSelectQueryPlan.determineRowTransformer(sqm, resultType, tupleMetadata, executionContext.getQueryOptions()), resultCountEstimate);
                return scrollableResultsImplementor;
            }
            finally {
                domainParameterXref.clearExpansions();
            }
        };
    }

    protected static SqmJdbcExecutionContextAdapter listInterpreterExecutionContext(String hql, DomainQueryExecutionContext executionContext, JdbcOperationQuerySelect jdbcSelect, SubselectFetch.RegistrationHandler subSelectFetchKeyHandler) {
        return new MySqmJdbcExecutionContextAdapter(executionContext, jdbcSelect, subSelectFetchKeyHandler, hql);
    }

    protected static int interpretIntExpression(Expression expression, JdbcParameterBindings jdbcParameterBindings) {
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            return ((Number)literal.getLiteralValue()).intValue();
        }
        if (expression instanceof JdbcParameter) {
            JdbcParameter jdbcParameter = (JdbcParameter)expression;
            return (Integer)jdbcParameterBindings.getBinding(jdbcParameter).getBindValue();
        }
        if (expression instanceof SqmParameterInterpretation) {
            SqmParameterInterpretation parameterInterpretation = (SqmParameterInterpretation)expression;
            JdbcParameter jdbcParameter = (JdbcParameter)parameterInterpretation.getResolvedExpression();
            return (Integer)jdbcParameterBindings.getBinding(jdbcParameter).getBindValue();
        }
        return -1;
    }

    private static List<SqmSelection<?>> selections(SqmSelectStatement<?> sqm) {
        return ((SqmQueryPart)sqm.getQueryPart()).getFirstQuerySpec().getSelectClause().getSelections();
    }

    protected static <T> RowTransformer<T> determineRowTransformer(SqmSelectStatement<?> sqm, Class<T> resultClass, TupleMetadata tupleMetadata, QueryOptions queryOptions) {
        if (queryOptions.getTupleTransformer() != null) {
            return ConcreteSqmSelectQueryPlan.makeRowTransformerTupleTransformerAdapter(sqm, queryOptions);
        }
        if (resultClass == null || resultClass == Object.class) {
            return RowTransformerStandardImpl.instance();
        }
        List<SqmSelection<?>> selections = ConcreteSqmSelectQueryPlan.selections(sqm);
        if (selections == null) {
            throw new AssertionFailure("No selections");
        }
        Class<T> resultType = ConcreteSqmSelectQueryPlan.primitiveToWrapper(resultClass);
        return switch (selections.size()) {
            case 0 -> throw new AssertionFailure("No selections");
            case 1 -> ConcreteSqmSelectQueryPlan.singleItemRowTransformer(sqm, tupleMetadata, selections.get(0), resultType);
            default -> ConcreteSqmSelectQueryPlan.multipleItemRowTransformer(sqm, tupleMetadata, resultType);
        };
    }

    private static <T> Class<T> primitiveToWrapper(Class<T> resultClass) {
        return WRAPPERS.getOrDefault(resultClass, resultClass);
    }

    private static <T> RowTransformer<T> multipleItemRowTransformer(SqmSelectStatement<?> sqm, TupleMetadata tupleMetadata, Class<T> resultType) {
        if (resultType.isArray()) {
            return RowTransformerArrayImpl.instance();
        }
        if (List.class.equals(resultType)) {
            return RowTransformerListImpl.instance();
        }
        if (Tuple.class.equals(resultType)) {
            return new RowTransformerJpaTupleImpl(tupleMetadata);
        }
        if (Map.class.equals(resultType)) {
            return new RowTransformerMapImpl(tupleMetadata);
        }
        if (ReflectHelper.isClass(resultType)) {
            return new RowTransformerConstructorImpl<T>(resultType, tupleMetadata, sqm.nodeBuilder().getTypeConfiguration());
        }
        throw new QueryTypeMismatchException("Result type '" + resultType.getSimpleName() + "' cannot be used to package the selected expressions");
    }

    private static <T> RowTransformer<T> singleItemRowTransformer(SqmSelectStatement<?> sqm, TupleMetadata tupleMetadata, SqmSelection<?> selection, Class<T> resultType) {
        if (SqmUtil.isSelectionAssignableToResultType(selection, resultType)) {
            return RowTransformerSingularReturnImpl.instance();
        }
        if (resultType.isArray()) {
            return RowTransformerArrayImpl.instance();
        }
        if (List.class.equals(resultType)) {
            return RowTransformerListImpl.instance();
        }
        if (Tuple.class.equals(resultType)) {
            return new RowTransformerJpaTupleImpl(tupleMetadata);
        }
        if (Map.class.equals(resultType)) {
            return new RowTransformerMapImpl(tupleMetadata);
        }
        if (ReflectHelper.isClass(resultType)) {
            try {
                return new RowTransformerConstructorImpl<T>(resultType, tupleMetadata, sqm.nodeBuilder().getTypeConfiguration());
            }
            catch (InstantiationException ie) {
                return new RowTransformerCheckingImpl<T>(resultType);
            }
        }
        return new RowTransformerCheckingImpl<T>(resultType);
    }

    private static <T> RowTransformer<T> makeRowTransformerTupleTransformerAdapter(SqmSelectStatement<?> sqm, QueryOptions queryOptions) {
        TupleTransformer<?> tupleTransformer = queryOptions.getTupleTransformer();
        return new RowTransformerTupleTransformerAdapter(ConcreteSqmSelectQueryPlan.adapterAliases(sqm), tupleTransformer);
    }

    private static String[] adapterAliases(SqmSelectStatement<?> sqm) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (SqmSelection<?> sqmSelection : ((SqmQuerySpec)sqm.getQuerySpec()).getSelectClause().getSelections()) {
            SqmSelectableNode<?> selectableNode = sqmSelection.getSelectableNode();
            if (selectableNode instanceof SqmDynamicInstantiation) {
                aliases.add(sqmSelection.getAlias());
                continue;
            }
            selectableNode.visitSubSelectableNodes(subSelection -> aliases.add(subSelection.getAlias()));
        }
        return ArrayHelper.toStringArray(aliases);
    }

    @Override
    public <T> T executeQuery(DomainQueryExecutionContext executionContext, ResultsConsumer<T, R> resultsConsumer) {
        SqmInterpreter<?, ? extends ResultsConsumer<?, R>> interpreter = this.executeQueryInterpreter;
        return (T)this.withCacheableSqmInterpretation(executionContext, resultsConsumer, interpreter);
    }

    @Override
    public List<R> performList(DomainQueryExecutionContext executionContext) {
        return executionContext.getQueryOptions().getEffectiveLimit().getMaxRowsJpa() == 0 ? Collections.emptyList() : this.withCacheableSqmInterpretation(executionContext, null, this.listInterpreter);
    }

    @Override
    public ScrollableResultsImplementor<R> performScroll(ScrollMode scrollMode, DomainQueryExecutionContext executionContext) {
        return executionContext.getQueryOptions().getEffectiveLimit().getMaxRowsJpa() == 0 ? EmptyScrollableResults.instance() : this.withCacheableSqmInterpretation(executionContext, scrollMode, this.scrollInterpreter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, X> T withCacheableSqmInterpretation(DomainQueryExecutionContext executionContext, X context, SqmInterpreter<T, X> interpreter) {
        CacheableSqmInterpretation<SelectStatement, JdbcOperationQuerySelect> localCopy = this.cacheableSqmInterpretation;
        JdbcParameterBindings jdbcParameterBindings = null;
        executionContext.getSession().autoPreFlush();
        if (localCopy == null) {
            ConcreteSqmSelectQueryPlan concreteSqmSelectQueryPlan = this;
            synchronized (concreteSqmSelectQueryPlan) {
                localCopy = this.cacheableSqmInterpretation;
                if (localCopy == null) {
                    MutableObject<JdbcParameterBindings> mutableValue = new MutableObject<JdbcParameterBindings>();
                    localCopy = ConcreteSqmSelectQueryPlan.buildInterpretation(this.sqm, this.domainParameterXref, executionContext, mutableValue);
                    jdbcParameterBindings = mutableValue.get();
                    this.cacheableSqmInterpretation = localCopy;
                } else {
                    if (localCopy.jdbcOperation().dependsOnParameterBindings()) {
                        jdbcParameterBindings = this.createJdbcParameterBindings(localCopy, executionContext);
                    }
                    if (!localCopy.jdbcOperation().isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
                        MutableObject<JdbcParameterBindings> mutableValue = new MutableObject<JdbcParameterBindings>();
                        localCopy = ConcreteSqmSelectQueryPlan.buildInterpretation(this.sqm, this.domainParameterXref, executionContext, mutableValue);
                        jdbcParameterBindings = mutableValue.get();
                        this.cacheableSqmInterpretation = localCopy;
                    }
                }
            }
        } else {
            if (localCopy.jdbcOperation().dependsOnParameterBindings()) {
                jdbcParameterBindings = this.createJdbcParameterBindings(localCopy, executionContext);
            }
            if (!localCopy.jdbcOperation().isCompatibleWith(jdbcParameterBindings, executionContext.getQueryOptions())) {
                MutableObject<JdbcParameterBindings> mutableValue = new MutableObject<JdbcParameterBindings>();
                localCopy = ConcreteSqmSelectQueryPlan.buildInterpretation(this.sqm, this.domainParameterXref, executionContext, mutableValue);
                jdbcParameterBindings = mutableValue.get();
                this.cacheableSqmInterpretation = localCopy;
            }
        }
        if (jdbcParameterBindings == null) {
            jdbcParameterBindings = this.createJdbcParameterBindings(localCopy, executionContext);
        }
        return interpreter.interpret(context, executionContext, localCopy, jdbcParameterBindings);
    }

    protected JdbcParameterBindings createJdbcParameterBindings(final CacheableSqmInterpretation<SelectStatement, JdbcOperationQuerySelect> sqmInterpretation, DomainQueryExecutionContext executionContext) {
        return SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, sqmInterpretation.jdbcParamsXref(), new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return sqmInterpretation.sqmParameterMappingModelTypes().get(parameter);
            }
        }, executionContext.getSession());
    }

    protected static CacheableSqmInterpretation<SelectStatement, JdbcOperationQuerySelect> buildInterpretation(SqmSelectStatement<?> sqm, DomainParameterXref domainParameterXref, DomainQueryExecutionContext executionContext, MutableObject<JdbcParameterBindings> firstJdbcParameterBindingsConsumer) {
        SharedSessionContractImplementor session = executionContext.getSession();
        SessionFactoryImplementor sessionFactory = session.getFactory();
        final SqmTranslation<SelectStatement> sqmInterpretation = sessionFactory.getQueryEngine().getSqmTranslatorFactory().createSelectTranslator(sqm, executionContext.getQueryOptions(), domainParameterXref, executionContext.getQueryParameterBindings(), executionContext.getSession().getLoadQueryInfluencers(), sessionFactory.getSqlTranslationEngine(), true).translate();
        SqlAstTranslator<JdbcOperationQuerySelect> selectTranslator = sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildSelectTranslator(sessionFactory, sqmInterpretation.getSqlAst());
        Map<QueryParameterImplementor<?>, Map<SqmParameter<?>, List<JdbcParametersList>>> jdbcParamsXref = SqmUtil.generateJdbcParamsXref(domainParameterXref, sqmInterpretation::getJdbcParamsBySqmParam);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), domainParameterXref, jdbcParamsXref, new SqmParameterMappingModelResolutionAccess(){

            @Override
            public <T> MappingModelExpressible<T> getResolvedMappingModelType(SqmParameter<T> parameter) {
                return sqmInterpretation.getSqmParameterMappingModelTypeResolutions().get(parameter);
            }
        }, session);
        firstJdbcParameterBindingsConsumer.set(jdbcParameterBindings);
        return new CacheableSqmInterpretation<SelectStatement, JdbcOperationQuerySelect>(sqmInterpretation.getSqlAst(), selectTranslator.translate(jdbcParameterBindings, executionContext.getQueryOptions()), jdbcParamsXref, sqmInterpretation.getSqmParameterMappingModelTypeResolutions());
    }

    private static interface SqmInterpreter<T, X> {
        public T interpret(X var1, DomainQueryExecutionContext var2, CacheableSqmInterpretation<SelectStatement, JdbcOperationQuerySelect> var3, JdbcParameterBindings var4);
    }

    private static class MySqmJdbcExecutionContextAdapter
    extends SqmJdbcExecutionContextAdapter {
        private final SubselectFetch.RegistrationHandler subSelectFetchKeyHandler;
        private final String hql;

        public MySqmJdbcExecutionContextAdapter(DomainQueryExecutionContext executionContext, JdbcOperationQuerySelect jdbcSelect, SubselectFetch.RegistrationHandler subSelectFetchKeyHandler, String hql) {
            super(executionContext, jdbcSelect);
            this.subSelectFetchKeyHandler = subSelectFetchKeyHandler;
            this.hql = hql;
        }

        @Override
        public void registerLoadingEntityHolder(EntityHolder holder) {
            this.subSelectFetchKeyHandler.addKey(holder);
        }

        @Override
        public String getQueryIdentifier(String sql) {
            return "<criteria>".equals(this.hql) ? "[CRITERIA] " + sql : this.hql;
        }
    }
}

