/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.search.backend.elasticsearch.logging.impl.ConfigurationLog;
import org.hibernate.search.engine.cfg.spi.ParseUtils;

public enum ElasticsearchDistributionName {
    ELASTIC("elastic", "elastic"),
    OPENSEARCH("opensearch", "opensearch"),
    AMAZON_OPENSEARCH_SERVERLESS("amazon-opensearch-serverless", null);

    private final String externalRepresentation;
    private final String serverResponseRepresentation;

    public static ElasticsearchDistributionName of(String value) {
        return (ElasticsearchDistributionName)((Object)ParseUtils.parseDiscreteValues((Object[])ElasticsearchDistributionName.values(), ElasticsearchDistributionName::externalRepresentation, ConfigurationLog.INSTANCE::invalidElasticsearchDistributionName, (String)value));
    }

    static List<String> allowedExternalRepresentations() {
        return Arrays.stream(ElasticsearchDistributionName.values()).map(ElasticsearchDistributionName::externalRepresentation).collect(Collectors.toList());
    }

    public static ElasticsearchDistributionName fromServerResponseRepresentation(String value) {
        return (ElasticsearchDistributionName)((Object)ParseUtils.parseDiscreteValues((Object[])ElasticsearchDistributionName.values(), ElasticsearchDistributionName::serverResponseRepresentation, ConfigurationLog.INSTANCE::invalidElasticsearchDistributionName, (String)value));
    }

    static ElasticsearchDistributionName defaultValue() {
        return ELASTIC;
    }

    private ElasticsearchDistributionName(String externalRepresentation, String serverResponseRepresentation) {
        this.externalRepresentation = externalRepresentation;
        this.serverResponseRepresentation = serverResponseRepresentation;
    }

    public String toString() {
        return this.externalRepresentation;
    }

    public String externalRepresentation() {
        return this.externalRepresentation;
    }

    String serverResponseRepresentation() {
        return this.serverResponseRepresentation;
    }
}

