/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.index.layout.impl;

import java.util.Locale;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchMiscLog;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;

public final class IndexNames {
    private final String hibernateSearch;
    private final URLEncodedString write;
    private final boolean writeIsAlias;
    private final URLEncodedString read;
    private final boolean readIsAlias;

    public static String normalizeName(String indexName) {
        String esIndexName = indexName.toLowerCase(Locale.ENGLISH);
        if (!esIndexName.equals(indexName)) {
            ElasticsearchMiscLog.INSTANCE.normalizeIndexName(indexName, esIndexName);
        }
        return esIndexName;
    }

    public static URLEncodedString encodeName(String name) {
        return name == null ? null : URLEncodedString.fromString(IndexNames.normalizeName(name));
    }

    public IndexNames(String hibernateSearch, URLEncodedString write, boolean writeIsAlias, URLEncodedString read, boolean readIsAlias) {
        this.hibernateSearch = hibernateSearch;
        this.write = write;
        this.writeIsAlias = writeIsAlias;
        this.read = read;
        this.readIsAlias = readIsAlias;
    }

    public String toString() {
        return "IndexNames[hibernateSearch=" + this.hibernateSearch + ", read=" + String.valueOf(this.read) + ", write=" + String.valueOf(this.write) + ", readIsAlias=" + this.readIsAlias + ", writeIsAlias=" + this.writeIsAlias + "]";
    }

    public String hibernateSearchIndex() {
        return this.hibernateSearch;
    }

    public URLEncodedString write() {
        return this.write;
    }

    public boolean writeIsAlias() {
        return this.writeIsAlias;
    }

    public URLEncodedString read() {
        return this.read;
    }

    public boolean readIsAlias() {
        return this.readIsAlias;
    }
}

