/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import com.google.gson.JsonObject;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchRequest;
import org.hibernate.search.backend.elasticsearch.client.spi.ElasticsearchResponse;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchJsonObjectFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchRequestFormatter;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchResponseFormatter;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.SearchTimeoutException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.DurationInSecondsAndFractionsFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@CategorizedLogger(category="org.hibernate.search.elasticsearch.client", description="Logs information on low-level Elasticsearch backend operations.\n+\nThis may include warnings about misconfigured Elasticsearch REST clients or index operations.\n")
@MessageLogger(projectCode="HSEARCH")
public interface ElasticsearchClientLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.elasticsearch.client";
    public static final ElasticsearchClientLog INSTANCE = (ElasticsearchClientLog)LoggerFactory.make(ElasticsearchClientLog.class, (String)"org.hibernate.search.elasticsearch.client", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=400007, value="Elasticsearch request failed: %3$s\nRequest: %1$s\nResponse: %2$s")
    public SearchException elasticsearchRequestFailed(@FormatWith(value=ElasticsearchRequestFormatter.class) ElasticsearchRequest var1, @FormatWith(value=ElasticsearchResponseFormatter.class) ElasticsearchResponse var2, String var3, @Cause Exception var4);

    @Message(id=400008, value="Elasticsearch bulked request failed: %3$s\nRequest metadata: %1$sResponse: %2$s")
    public SearchException elasticsearchBulkedRequestFailed(@FormatWith(value=ElasticsearchJsonObjectFormatter.class) JsonObject var1, @FormatWith(value=ElasticsearchJsonObjectFormatter.class) JsonObject var2, String var3, @Cause Exception var4);

    @Message(id=400010, value="Elasticsearch response indicates a timeout (HTTP status 408)")
    public SearchException elasticsearchStatus408RequestTimeout();

    @Message(id=400020, value="Unable to update mapping for index '%1$s': %2$s")
    public SearchException elasticsearchMappingUpdateFailed(String var1, String var2, @Cause Exception var3);

    @Message(id=400024, value="Index '%1$s' failed to reach status '%2$s' after %3$sms.")
    public SearchException unexpectedIndexStatus(URLEncodedString var1, String var2, int var3, @Cause Exception var4);

    @Message(id=400034, value="Unable to retrieve index metadata from Elasticsearch: %1$s")
    public SearchException elasticsearchIndexMetadataRetrievalFailed(String var1, @Cause Throwable var2);

    @Message(id=400035, value="Unable to update schema for index '%1$s': %2$s")
    public SearchException schemaUpdateFailed(URLEncodedString var1, String var2, @Cause Exception var3);

    @Message(id=400050, value="Missing index: index names [%1$s, %2$s] do not point to any index in the Elasticsearch cluster.")
    public SearchException indexMissing(URLEncodedString var1, URLEncodedString var2);

    @Message(id=400067, value="Unable to update settings for index '%1$s': %2$s")
    public SearchException elasticsearchSettingsUpdateFailed(Object var1, String var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=400069, value="Closed Elasticsearch index '%1$s' automatically.")
    public void closedIndex(Object var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=400070, value="Opened Elasticsearch index '%1$s' automatically.")
    public void openedIndex(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400073, value="Hibernate Search will connect to Elasticsearch with authentication over plain HTTP (not HTTPS). The password will be sent in clear text over the network.")
    public void usingPasswordOverHttp();

    @Message(id=400089, value="Unable to parse Elasticsearch response. Status code was '%1$d', status phrase was '%2$s'. Nested exception: %3$s")
    public SearchException failedToParseElasticsearchResponse(int var1, String var2, String var3, @Cause Exception var4);

    @Message(id=400090, value="Elasticsearch response indicates a failure.")
    public SearchException elasticsearchResponseIndicatesFailure();

    @Message(id=400525, value="Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.")
    public SearchException invalidFieldForDocumentElement(String var1, String var2);

    @Message(id=400526, value="Missing data in the Elasticsearch response.")
    public AssertionFailure elasticsearchResponseMissingData();

    @Message(id=400531, value="Unable to resolve index name '%1$s' to an entity type: %2$s")
    public SearchException elasticsearchResponseUnknownIndexName(String var1, String var2, @Cause Exception var3);

    @Message(id=400544, value="Unable to shut down the Elasticsearch client: %1$s")
    public SearchException unableToShutdownClient(String var1, @Cause Exception var2);

    @Message(id=400588, value="Call to the bulk REST API failed: %1$s")
    public SearchException elasticsearchFailedBecauseOfBulkFailure(String var1, @Cause Throwable var2);

    @Message(id=400590, value="Request execution exceeded the timeout of %1$s. Request was %2$s")
    public SearchTimeoutException requestTimedOut(@FormatWith(value=DurationInSecondsAndFractionsFormatter.class) Duration var1, @FormatWith(value=ElasticsearchRequestFormatter.class) ElasticsearchRequest var2);

    @Message(id=400593, value="Invalid Elasticsearch index layout: index names [%1$s, %2$s] resolve to multiple distinct indexes %3$s. These names must resolve to a single index.")
    public SearchException elasticsearchIndexNameAndAliasesMatchMultipleIndexes(URLEncodedString var1, URLEncodedString var2, Set<String> var3);

    @Message(id=400594, value="Invalid Elasticsearch index layout: primary (non-alias) name for existing Elasticsearch index '%1$s' does not match the expected pattern '%2$s'.")
    public SearchException invalidIndexPrimaryName(String var1, Pattern var2);

    @Message(id=400595, value="Invalid Elasticsearch index layout: unique key '%1$s' extracted from the index name does not match any of %2$s.")
    public SearchException invalidIndexUniqueKey(String var1, Set<String> var2);

    @Message(id=400625, value="Unable to update aliases for index '%1$s': %2$s")
    public SearchException elasticsearchAliasUpdateFailed(Object var1, String var2, @Cause Exception var3);
}

